"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HighlightedFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _expandableFlyout = require("@kbn/expandable-flyout");
var _eui = require("@elastic/eui");
var _test_ids = require("./test_ids");
var _alert_summary_view = require("../../../common/components/event_details/alert_summary_view");
var _translations = require("./translations");
var _context = require("../context");
var _ = require("..");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component that displays the highlighted fields in the right panel under the Investigation section.
 * It leverages the existing {@link AlertSummaryView} component.
 * // TODO will require improvements https://github.com/elastic/security-team/issues/6428
 */
const HighlightedFields = () => {
  const {
    openRightPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const {
    eventId,
    indexName,
    dataFormattedForFieldBrowser,
    browserFields,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const goToTableTab = (0, _react.useCallback)(() => {
    openRightPanel({
      id: _.RightPanelKey,
      path: _.RightPanelTableTabPath,
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, indexName, openRightPanel, scopeId]);
  if (!dataFormattedForFieldBrowser || !browserFields || !eventId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_TITLE_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs"
  }, /*#__PURE__*/_react.default.createElement("h5", null, _translations.HIGHLIGHTED_FIELDS_TITLE))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": _test_ids.HIGHLIGHTED_FIELDS_DETAILS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_alert_summary_view.AlertSummaryView // TODO consider using x-pack/plugins/security_solution/public/common/components/event_details/summary_view.tsx instead if the link to the table have to be removed
  , {
    data: dataFormattedForFieldBrowser,
    eventId: eventId,
    browserFields: browserFields,
    isDraggable: false,
    scopeId: scopeId,
    title: '',
    isReadOnly: false // TODO: set properly
    ,
    goToTable: goToTableTab
  }))));
};
exports.HighlightedFields = HighlightedFields;