"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CorrelationsOverview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _expandableFlyout = require("@kbn/expandable-flyout");
var _insights_summary_row = require("./insights_summary_row");
var _use_correlations = require("../../shared/hooks/use_correlations");
var _test_ids = require("./test_ids");
var _insights_subsection = require("./insights_subsection");
var _context = require("../context");
var _translations = require("./translations");
var _left = require("../../left");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Correlations section under Insights section, overview tab.
 * The component fetches the necessary data, then pass it down to the InsightsSubSection component for loading and error state,
 * and the SummaryPanel component for data rendering.
 */
const CorrelationsOverview = () => {
  const {
    eventId,
    indexName,
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    scopeId
  } = (0, _context.useRightPanelContext)();
  const {
    openLeftPanel
  } = (0, _expandableFlyout.useExpandableFlyoutContext)();
  const goToCorrelationsTab = (0, _react.useCallback)(() => {
    openLeftPanel({
      id: _left.LeftPanelKey,
      path: _left.LeftPanelInsightsTabPath,
      params: {
        id: eventId,
        indexName,
        scopeId
      }
    });
  }, [eventId, openLeftPanel, indexName, scopeId]);
  const {
    loading,
    error,
    data
  } = (0, _use_correlations.useCorrelations)({
    eventId,
    dataAsNestedObject,
    dataFormattedForFieldBrowser,
    scopeId
  });
  const correlationRows = (0, _react.useMemo)(() => data.map(d => /*#__PURE__*/_react.default.createElement(_insights_summary_row.InsightsSummaryRow, {
    icon: d.icon,
    value: d.value,
    text: d.text,
    "data-test-subj": _test_ids.INSIGHTS_CORRELATIONS_TEST_ID,
    key: `correlation-row-${d.text}`
  })), [data]);
  return /*#__PURE__*/_react.default.createElement(_insights_subsection.InsightsSubSection, {
    loading: loading,
    error: error,
    title: _translations.CORRELATIONS_TITLE,
    "data-test-subj": _test_ids.INSIGHTS_CORRELATIONS_TEST_ID
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasShadow: false,
    hasBorder: true,
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, correlationRows)), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: goToCorrelationsTab,
    iconType: "arrowStart",
    iconSide: "left",
    size: "s",
    "data-test-subj": `${_test_ids.INSIGHTS_CORRELATIONS_TEST_ID}ViewAllButton`
  }, (0, _translations.VIEW_ALL)(_translations.CORRELATIONS_TEXT)));
};
exports.CorrelationsOverview = CorrelationsOverview;
CorrelationsOverview.displayName = 'CorrelationsOverview';