"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PrevalenceDetailsCountCell = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _test_ids = require("./test_ids");
var _use_fetch_field_value_pair_by_event_type = require("../../shared/hooks/use_fetch_field_value_pair_by_event_type");
var _types = require("../../../../common/types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Component displaying a value in many PrevalenceDetails table cells. It is used for the third and fourth columns,
 * which display the number of alerts and documents for a given field/value pair.
 * For the doc columns, type should "signal" for its eventKind property, and exclude set to true.
 * For the alert columns, type should have "signal" for its eventKind property, and include should be true.
 */
const PrevalenceDetailsCountCell = ({
  highlightedField,
  scopeId,
  type
}) => {
  const {
    loading,
    error,
    count
  } = (0, _use_fetch_field_value_pair_by_event_type.useFetchFieldValuePairByEventType)({
    highlightedField,
    isActiveTimelines: scopeId === _types.TimelineId.active,
    type
  });
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
      "data-test-subj": _test_ids.PREVALENCE_DETAILS_COUNT_CELL_LOADING_TEST_ID
    });
  }
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": _test_ids.PREVALENCE_DETAILS_COUNT_CELL_ERROR_TEST_ID,
      type: "error",
      color: "danger"
    });
  }
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": _test_ids.PREVALENCE_DETAILS_COUNT_CELL_VALUE_TEST_ID
  }, count);
};
exports.PrevalenceDetailsCountCell = PrevalenceDetailsCountCell;
PrevalenceDetailsCountCell.displayName = 'PrevalenceDetailsCountCell';