"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UsersContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../../../common/constants");
var _model = require("../store/model");
var _users = require("./users");
var _details = require("./details");
var _constants2 = require("./constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UsersContainer = /*#__PURE__*/_react.default.memo(() => {
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.usersTabPath
  }, /*#__PURE__*/_react.default.createElement(_users.Users, null)), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Compatibility redirect for the old external alert path to events page with external alerts showing.
  , {
    path: `${_constants.USERS_PATH}/externalAlerts`,
    render: ({
      location: {
        search = ''
      }
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: `${_constants.USERS_PATH}/${_model.UsersTableType.events}`,
        search: `${search}&onlyExternalAlerts=true`
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: _constants2.usersDetailsTabPath,
    render: ({
      match: {
        params: {
          detailName
        }
      }
    }) => /*#__PURE__*/_react.default.createElement(_details.UsersDetails, {
      usersDetailsPagePath: _constants2.usersDetailsPagePath,
      detailName: decodeURIComponent(detailName)
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Redirect to the first tab when tabName is not present.
  , {
    path: _constants2.usersDetailsPagePath,
    render: ({
      match: {
        params: {
          detailName
        }
      },
      location: {
        search = ''
      }
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: `${_constants.USERS_PATH}/name/${detailName}/${_model.UsersTableType.authentications}`,
        search
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Compatibility redirect for the old user detail path.
  , {
    path: `${_constants.USERS_PATH}/:detailName/:tabName?`,
    render: ({
      match: {
        params: {
          detailName,
          tabName = _model.UsersTableType.authentications
        }
      },
      location: {
        search = ''
      }
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: `${_constants.USERS_PATH}/name/${detailName}/${tabName}`,
        search
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Redirect to the first tab when tabName is not present.
  , {
    path: _constants.USERS_PATH,
    render: ({
      location: {
        search = ''
      }
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        pathname: `${_constants.USERS_PATH}/${_model.UsersTableType.allUsers}`,
        search
      }
    })
  }));
});
exports.UsersContainer = UsersContainer;
UsersContainer.displayName = 'UsersContainer';