"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.navTabsUsersDetails = void 0;
var _fp = require("lodash/fp");
var i18n = _interopRequireWildcard(require("../translations"));
var _model = require("../../store/model");
var _constants = require("../../../../../common/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getTabsOnUsersDetailsUrl = (userName, tabName) => `${_constants.USERS_PATH}/name/${userName}/${tabName}`;
const navTabsUsersDetails = (userName, hasMlUserPermissions, isRiskyUserEnabled) => {
  const hiddenTabs = [];
  const userDetailsNavTabs = {
    [_model.UsersTableType.authentications]: {
      id: _model.UsersTableType.authentications,
      name: i18n.NAVIGATION_AUTHENTICATIONS_TITLE,
      href: getTabsOnUsersDetailsUrl(userName, _model.UsersTableType.authentications),
      disabled: false
    },
    [_model.UsersTableType.anomalies]: {
      id: _model.UsersTableType.anomalies,
      name: i18n.NAVIGATION_ANOMALIES_TITLE,
      href: getTabsOnUsersDetailsUrl(userName, _model.UsersTableType.anomalies),
      disabled: false
    },
    [_model.UsersTableType.events]: {
      id: _model.UsersTableType.events,
      name: i18n.NAVIGATION_EVENTS_TITLE,
      href: getTabsOnUsersDetailsUrl(userName, _model.UsersTableType.events),
      disabled: false
    },
    [_model.UsersTableType.risk]: {
      id: _model.UsersTableType.risk,
      name: i18n.NAVIGATION_RISK_TITLE,
      href: getTabsOnUsersDetailsUrl(userName, _model.UsersTableType.risk),
      disabled: false
    }
  };
  if (!hasMlUserPermissions) {
    hiddenTabs.push(_model.UsersTableType.anomalies);
  }
  if (!isRiskyUserEnabled) {
    hiddenTabs.push(_model.UsersTableType.risk);
  }
  return (0, _fp.omit)(hiddenTabs, userDetailsNavTabs);
};
exports.navTabsUsersDetails = navTabsUsersDetails;