"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fieldsMapping = exports.TotalUsersKpi = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _users = require("../../../../../../common/search_strategy/security_solution/users");
var _use_search_strategy = require("../../../../../common/containers/use_search_strategy");
var _common = require("../../../../hosts/components/kpi_hosts/common");
var _kpi_total_users_metric = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_total_users_metric");
var _kpi_total_users_area = require("../../../../../common/components/visualization_actions/lens_attributes/users/kpi_total_users_area");
var i18n = _interopRequireWildcard(require("./translations"));
var _query_toggle = require("../../../../../common/containers/query_toggle");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _use_refetch_by_session = require("../../../../../common/components/page/use_refetch_by_session");
var _constants = require("../../../../../common/store/inputs/constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const euiVisColorPalette = (0, _eui.euiPaletteColorBlind)();
const euiColorVis1 = euiVisColorPalette[1];
const fieldsMapping = [{
  key: 'users',
  fields: [{
    key: 'users',
    value: null,
    color: euiColorVis1,
    icon: 'storage',
    lensAttributes: _kpi_total_users_metric.kpiTotalUsersMetricLensAttributes
  }],
  enableAreaChart: true,
  description: i18n.USERS,
  areaChartLensAttributes: _kpi_total_users_area.kpiTotalUsersAreaLensAttributes
}];
exports.fieldsMapping = fieldsMapping;
const QUERY_ID = 'TotalUsersKpiQuery';
const TotalUsersKpiComponent = ({
  filterQuery,
  from,
  indexNames,
  to,
  updateDateRange,
  setQuery,
  skip
}) => {
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(QUERY_ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  const isChartEmbeddablesEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('chartEmbeddablesEnabled');
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const {
    loading,
    result,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _users.UsersQueries.kpiTotalUsers,
    initialResult: {
      users: 0,
      usersHistogram: []
    },
    errorMessage: i18n.ERROR_USERS_KPI,
    abort: querySkip || isChartEmbeddablesEnabled
  });
  const {
    session,
    refetchByRestartingSession
  } = (0, _use_refetch_by_session.useRefetchByRestartingSession)({
    inputId: _constants.InputsModelId.global,
    queryId: QUERY_ID
  });
  (0, _react.useEffect)(() => {
    if (!querySkip) {
      search({
        filterQuery,
        defaultIndex: indexNames,
        timerange: {
          interval: '12h',
          from,
          to
        }
      });
    }
  }, [search, from, to, filterQuery, indexNames, querySkip]);
  return /*#__PURE__*/_react.default.createElement(_common.KpiBaseComponentManage, {
    data: result,
    id: QUERY_ID,
    inspect: inspect,
    loading: loading,
    fieldsMapping: fieldsMapping,
    from: from,
    to: to,
    updateDateRange: updateDateRange,
    refetch: isChartEmbeddablesEnabled ? refetchByRestartingSession : refetch,
    setQuery: setQuery,
    setQuerySkip: setQuerySkip,
    session: isChartEmbeddablesEnabled ? session : undefined
  });
};
const TotalUsersKpi = /*#__PURE__*/_react.default.memo(TotalUsersKpiComponent);
exports.TotalUsersKpi = TotalUsersKpi;