"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkKpiNetworkEvents = exports.ID = void 0;
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _fp = require("lodash/fp");
var _react = require("react");
var _rxjs = require("rxjs");
var _common = require("@kbn/data-plugin/common");
var _use_app_toasts = require("../../../../../common/hooks/use_app_toasts");
var _helpers = require("../../../../../common/containers/helpers");
var _kibana = require("../../../../../common/lib/kibana");
var _search_strategy = require("../../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers2 = require("../../../../../helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = 'networkKpiNetworkEventsQuery';
exports.ID = ID;
const useNetworkKpiNetworkEvents = ({
  filterQuery,
  endDate,
  indexNames,
  skip = false,
  startDate
}) => {
  const {
    data
  } = (0, _kibana.useKibana)().services;
  const refetch = (0, _react.useRef)(_fp.noop);
  const abortCtrl = (0, _react.useRef)(new AbortController());
  const searchSubscription$ = (0, _react.useRef)(new _rxjs.Subscription());
  const [loading, setLoading] = (0, _react.useState)(false);
  const [networkKpiNetworkEventsRequest, setNetworkKpiNetworkEventsRequest] = (0, _react.useState)(null);
  const [networkKpiNetworkEventsResponse, setNetworkKpiNetworkEventsResponse] = (0, _react.useState)({
    networkEvents: 0,
    id: ID,
    inspect: {
      dsl: [],
      response: []
    },
    isInspected: false,
    refetch: refetch.current
  });
  const {
    addError,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const networkKpiNetworkEventsSearch = (0, _react.useCallback)(request => {
    if (request == null || skip) {
      return;
    }
    const asyncSearch = async () => {
      abortCtrl.current = new AbortController();
      setLoading(true);
      searchSubscription$.current = data.search.search(request, {
        strategy: 'securitySolutionSearchStrategy',
        abortSignal: abortCtrl.current.signal
      }).subscribe({
        next: response => {
          if ((0, _common.isCompleteResponse)(response)) {
            setLoading(false);
            setNetworkKpiNetworkEventsResponse(prevResponse => ({
              ...prevResponse,
              networkEvents: response.networkEvents,
              inspect: (0, _helpers2.getInspectResponse)(response, prevResponse.inspect),
              refetch: refetch.current
            }));
            searchSubscription$.current.unsubscribe();
          } else if ((0, _common.isErrorResponse)(response)) {
            setLoading(false);
            addWarning(i18n.ERROR_NETWORK_KPI_NETWORK_EVENTS);
            searchSubscription$.current.unsubscribe();
          }
        },
        error: msg => {
          setLoading(false);
          addError(msg, {
            title: i18n.FAIL_NETWORK_KPI_NETWORK_EVENTS
          });
          searchSubscription$.current.unsubscribe();
        }
      });
    };
    searchSubscription$.current.unsubscribe();
    abortCtrl.current.abort();
    asyncSearch();
    refetch.current = asyncSearch;
  }, [data.search, addError, addWarning, skip]);
  (0, _react.useEffect)(() => {
    setNetworkKpiNetworkEventsRequest(prevRequest => {
      const myRequest = {
        ...(prevRequest !== null && prevRequest !== void 0 ? prevRequest : {}),
        defaultIndex: indexNames,
        factoryQueryType: _search_strategy.NetworkKpiQueries.networkEvents,
        filterQuery: (0, _helpers.createFilter)(filterQuery),
        timerange: {
          interval: '12h',
          from: startDate,
          to: endDate
        }
      };
      if (!(0, _fastDeepEqual.default)(prevRequest, myRequest)) {
        return myRequest;
      }
      return prevRequest;
    });
  }, [indexNames, endDate, filterQuery, startDate]);
  (0, _react.useEffect)(() => {
    networkKpiNetworkEventsSearch(networkKpiNetworkEventsRequest);
    return () => {
      searchSubscription$.current.unsubscribe();
      abortCtrl.current.abort();
    };
  }, [networkKpiNetworkEventsRequest, networkKpiNetworkEventsSearch]);
  (0, _react.useEffect)(() => {
    if (skip) {
      setLoading(false);
      searchSubscription$.current.unsubscribe();
      abortCtrl.current.abort();
    }
  }, [skip]);
  return [loading, networkKpiNetworkEventsResponse];
};
exports.useNetworkKpiNetworkEvents = useNetworkKpiNetworkEvents;