"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useNetworkDetails = exports.ID = void 0;
var _react = require("react");
var _helpers = require("../../../../common/containers/helpers");
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ID = 'networkDetailsQuery';
exports.ID = ID;
const useNetworkDetails = ({
  filterQuery,
  id = ID,
  indexNames,
  ip,
  skip
}) => {
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType: _search_strategy.NetworkQueries.details,
    initialResult: {
      networkDetails: {}
    },
    errorMessage: i18n.ERROR_NETWORK_DETAILS,
    abort: skip
  });
  const networkDetailsResponse = (0, _react.useMemo)(() => ({
    networkDetails: response.networkDetails,
    id,
    inspect,
    isInspected: false,
    refetch
  }), [id, inspect, refetch, response.networkDetails]);
  const networkDetailsRequest = (0, _react.useMemo)(() => ({
    defaultIndex: indexNames,
    factoryQueryType: _search_strategy.NetworkQueries.details,
    filterQuery: (0, _helpers.createFilter)(filterQuery),
    ip
  }), [filterQuery, indexNames, ip]);
  (0, _react.useEffect)(() => {
    if (!skip && networkDetailsRequest) {
      search(networkDetailsRequest);
    }
  }, [networkDetailsRequest, search, skip]);
  return [loading, networkDetailsResponse];
};
exports.useNetworkDetails = useNetworkDetails;