"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LineToolTipContentComponent = exports.LineToolTipContent = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _source_destination_arrows = require("../../source_destination/source_destination_arrows");
var _map_config = require("../map_config");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FlowBadge = (0, _styledComponents.default)(_eui.EuiBadge)`
  height: 45px;
  min-width: 85px;
`;
const EuiFlexGroupStyled = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin: 0 auto;
`;
const LineToolTipContentComponent = ({
  contextId,
  featureProps
}) => {
  const lineProps = featureProps.reduce((acc, f) => {
    var _f$getRawValue;
    const rawValue = (_f$getRawValue = f.getRawValue()) !== null && _f$getRawValue !== void 0 ? _f$getRawValue : [];
    return {
      ...acc,
      ...{
        [f.getPropertyKey()]: Array.isArray(rawValue) ? rawValue : [rawValue]
      }
    };
  }, {});
  const isSrcDest = Object.keys(lineProps).includes(_map_config.SUM_OF_SOURCE_BYTES);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "center",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(FlowBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(EuiFlexGroupStyled, {
    direction: "column"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isSrcDest ? i18n.SOURCE : i18n.CLIENT)))), /*#__PURE__*/_react.default.createElement(_source_destination_arrows.SourceDestinationArrows, {
    contextId: contextId,
    destinationBytes: isSrcDest ? lineProps[_map_config.SUM_OF_DESTINATION_BYTES] : lineProps[_map_config.SUM_OF_SERVER_BYTES],
    eventId: `map-line-tooltip-${contextId}`,
    sourceBytes: isSrcDest ? lineProps[_map_config.SUM_OF_SOURCE_BYTES] : lineProps[_map_config.SUM_OF_CLIENT_BYTES]
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(FlowBadge, {
    color: "hollow"
  }, /*#__PURE__*/_react.default.createElement(EuiFlexGroupStyled, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, isSrcDest ? i18n.DESTINATION : i18n.SERVER)))));
};
exports.LineToolTipContentComponent = LineToolTipContentComponent;
LineToolTipContentComponent.displayName = 'LineToolTipContentComponent';
const LineToolTipContent = /*#__PURE__*/_react.default.memo(LineToolTipContentComponent);
exports.LineToolTipContent = LineToolTipContent;
LineToolTipContent.displayName = 'LineToolTipContent';