"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRiskScore = exports.initialResult = void 0;
var _react = require("react");
var _feature_status = require("../feature_status");
var _helpers = require("../../../../common/containers/helpers");
var _search_strategy = require("../../../../../common/search_strategy");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _exceptions = require("../../../../common/utils/exceptions");
var _use_space_id = require("../../../../common/hooks/use_space_id");
var _use_search_strategy = require("../../../../common/containers/use_search_strategy");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initialResult = {
  totalCount: 0,
  data: undefined
};
exports.initialResult = initialResult;
const useRiskScore = ({
  timerange,
  onlyLatest = true,
  filterQuery,
  sort,
  skip = false,
  pagination,
  riskEntity,
  includeAlertsCount = false
}) => {
  const spaceId = (0, _use_space_id.useSpaceId)();
  const defaultIndex = spaceId ? riskEntity === _search_strategy.RiskScoreEntity.host ? (0, _search_strategy.getHostRiskIndex)(spaceId, onlyLatest) : (0, _search_strategy.getUserRiskIndex)(spaceId, onlyLatest) : undefined;
  const factoryQueryType = riskEntity === _search_strategy.RiskScoreEntity.host ? _search_strategy.RiskQueries.hostsRiskScore : _search_strategy.RiskQueries.usersRiskScore;
  const {
    querySize,
    cursorStart
  } = pagination || {};
  const {
    addError
  } = (0, _use_app_toasts.useAppToasts)();
  const {
    isDeprecated,
    isEnabled,
    isLicenseValid,
    isLoading: isDeprecatedLoading,
    refetch: refetchDeprecated
  } = (0, _feature_status.useRiskScoreFeatureStatus)(riskEntity, defaultIndex);
  const {
    loading,
    result: response,
    search,
    refetch,
    inspect,
    error
  } = (0, _use_search_strategy.useSearchStrategy)({
    factoryQueryType,
    initialResult,
    abort: skip,
    showErrorToast: false
  });
  const refetchAll = (0, _react.useCallback)(() => {
    if (defaultIndex) {
      refetchDeprecated(defaultIndex);
      refetch();
    }
  }, [defaultIndex, refetch, refetchDeprecated]);

  // since query does not take timerange arg, we need to manually refetch when time range updates
  // the results can be different if the user has run the ML for the first time since pressing refresh
  (0, _react.useEffect)(() => {
    refetchAll();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [timerange === null || timerange === void 0 ? void 0 : timerange.to, timerange === null || timerange === void 0 ? void 0 : timerange.from]);
  const riskScoreResponse = (0, _react.useMemo)(() => ({
    data: response.data,
    inspect,
    refetch: refetchAll,
    totalCount: response.totalCount,
    isLicenseValid,
    isDeprecated,
    isModuleEnabled: isEnabled,
    isInspected: false
  }), [inspect, isDeprecated, isEnabled, isLicenseValid, refetchAll, response.data, response.totalCount]);
  const requestTimerange = (0, _react.useMemo)(() => timerange ? {
    to: timerange.to,
    from: timerange.from,
    interval: ''
  } : undefined, [timerange]);
  const riskScoreRequest = (0, _react.useMemo)(() => defaultIndex ? {
    defaultIndex: [defaultIndex],
    factoryQueryType,
    riskScoreEntity: riskEntity,
    includeAlertsCount,
    filterQuery: (0, _helpers.createFilter)(filterQuery),
    pagination: cursorStart !== undefined && querySize !== undefined ? {
      cursorStart,
      querySize
    } : undefined,
    sort,
    timerange: onlyLatest ? undefined : requestTimerange,
    alertsTimerange: includeAlertsCount ? requestTimerange : undefined
  } : null, [cursorStart, defaultIndex, factoryQueryType, filterQuery, querySize, sort, requestTimerange, onlyLatest, riskEntity, includeAlertsCount]);
  (0, _react.useEffect)(() => {
    if (error) {
      if (!(0, _exceptions.isIndexNotFoundError)(error)) {
        addError(error, {
          title: i18n.FAIL_RISK_SCORE
        });
      }
    }
  }, [addError, error]);
  (0, _react.useEffect)(() => {
    if (!skip && !isDeprecatedLoading && riskScoreRequest != null && isLicenseValid && isEnabled && !isDeprecated) {
      search(riskScoreRequest);
    }
  }, [isEnabled, isDeprecated, isLicenseValid, isDeprecatedLoading, riskScoreRequest, search, skip]);
  return {
    ...riskScoreResponse,
    loading: loading || isDeprecatedLoading
  };
};
exports.useRiskScore = useRiskScore;