"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.statItemChartCustomHeight = exports.statItemBarchartRotation = exports.numberFormatter = exports.barchartConfigs = exports.areachartConfigs = exports.addValueToFields = exports.addValueToBarChart = exports.addValueToAreaChart = exports.StyledTitle = exports.StatValue = exports.MetricItem = exports.FlexItem = exports.FlexGroup = exports.ChartHeight = void 0;
var _charts = require("@elastic/charts");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ChartHeight = 120;
exports.ChartHeight = ChartHeight;
const FlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  .no-margin {
    margin-top: 0 !important;
    margin-bottom: 0 !important;
  }
`;
exports.FlexGroup = FlexGroup;
const FlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 0;
  position: relative;
`;
exports.FlexItem = FlexItem;
FlexItem.displayName = 'FlexItem';
const MetricItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  &.euiFlexItem {
    flex-basis: 0;
    flex-grow: 0;
  }
`;
exports.MetricItem = MetricItem;
MetricItem.displayName = 'MetricItem';
const StatValue = (0, _styledComponents.default)(_eui.EuiTitle)`
  overflow: hidden;
  text-overflow: ellipsis;
  white-space: nowrap;
`;
exports.StatValue = StatValue;
StatValue.displayName = 'StatValue';
const StyledTitle = _styledComponents.default.h6`
  line-height: 200%;
`;
exports.StyledTitle = StyledTitle;
const numberFormatter = value => value.toLocaleString();
exports.numberFormatter = numberFormatter;
const statItemBarchartRotation = 90;
exports.statItemBarchartRotation = statItemBarchartRotation;
const statItemChartCustomHeight = 74;
exports.statItemChartCustomHeight = statItemChartCustomHeight;
const areachartConfigs = config => ({
  series: {
    xScaleType: _charts.ScaleType.Time,
    yScaleType: _charts.ScaleType.Linear
  },
  axis: {
    xTickFormatter: (0, _fp.get)('xTickFormatter', config),
    yTickFormatter: numberFormatter
  },
  settings: {
    onBrushEnd: (0, _fp.getOr)(() => {}, 'onBrushEnd', config)
  },
  customHeight: statItemChartCustomHeight
});
exports.areachartConfigs = areachartConfigs;
const barchartConfigs = config => ({
  series: {
    xScaleType: _charts.ScaleType.Ordinal,
    yScaleType: _charts.ScaleType.Linear,
    stackAccessors: ['y0']
  },
  axis: {
    xTickFormatter: numberFormatter
  },
  settings: {
    onElementClick: (0, _fp.getOr)(() => {}, 'onElementClick', config),
    rotation: statItemBarchartRotation
  },
  customHeight: statItemChartCustomHeight
});
exports.barchartConfigs = barchartConfigs;
const addValueToFields = (fields, data) => fields.map(field => ({
  ...field,
  value: (0, _fp.get)(field.key, data)
}));
exports.addValueToFields = addValueToFields;
const addValueToAreaChart = (fields, data) => fields.filter(field => (0, _fp.get)(`${field.key}Histogram`, data) != null).map(({
  lensAttributes,
  ...field
}) => ({
  ...field,
  value: (0, _fp.get)(`${field.key}Histogram`, data),
  key: `${field.key}Histogram`
}));
exports.addValueToAreaChart = addValueToAreaChart;
const addValueToBarChart = (fields, data) => {
  if (fields.length === 0) return [];
  return fields.reduce((acc, field, idx) => {
    const {
      key,
      color
    } = field;
    const y = (0, _fp.getOr)(null, key, data);
    const x = (0, _fp.get)(`${idx}.name`, fields) || (0, _fp.getOr)('', `${idx}.description`, fields);
    const value = [{
      x,
      y,
      g: key,
      y0: 0
    }];
    return [...acc, {
      key,
      color,
      value
    }];
  }, []);
};
exports.addValueToBarChart = addValueToBarChart;