"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoresNoDataDetected = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _search_strategy = require("../../../../../common/search_strategy");
var _header_section = require("../../../../common/components/header_section");
var i18n = _interopRequireWildcard(require("./translations"));
var _risk_score_header_title = require("./risk_score_header_title");
var _risk_score_restart_button = require("./risk_score_restart_button");
var overviewI18n = _interopRequireWildcard(require("../../../../overview/components/entity_analytics/common/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoresNoDataDetectedComponent = ({
  entityType,
  refetch
}) => {
  const translations = (0, _react.useMemo)(() => ({
    title: entityType === _search_strategy.RiskScoreEntity.user ? i18n.USER_WARNING_TITLE : i18n.HOST_WARNING_TITLE,
    body: entityType === _search_strategy.RiskScoreEntity.user ? i18n.USER_WARNING_BODY : i18n.HOST_WARNING_BODY
  }), [entityType]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subj": `${entityType}-risk-score-no-data-detected`,
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
    title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
      riskScoreEntity: entityType
    }),
    titleSize: "s",
    tooltip: entityType === _search_strategy.RiskScoreEntity.user ? overviewI18n.USER_RISK_TABLE_TOOLTIP : overviewI18n.HOST_RISK_TABLE_TOOLTIP
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    title: /*#__PURE__*/_react.default.createElement("h2", null, translations.title),
    body: translations.body,
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: i18n.RESTART_TOOLTIP
    }, /*#__PURE__*/_react.default.createElement(_risk_score_restart_button.RiskScoreRestartButton, {
      refetch: refetch,
      riskScoreEntity: entityType
    }))
  }));
};
const RiskScoresNoDataDetected = /*#__PURE__*/_react.default.memo(RiskScoresNoDataDetectedComponent);
exports.RiskScoresNoDataDetected = RiskScoresNoDataDetected;
RiskScoresNoDataDetected.displayName = 'RiskScoresNoDataDetected';