"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RiskScoreDocLink = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _search_strategy = require("../../../../../common/search_strategy");
var _constants = require("../../../../../common/constants");
var _translations = require("../../../../overview/components/entity_analytics/risk_score/translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RiskScoreDocLinkComponent = ({
  riskScoreEntity,
  title
}) => {
  const docLink = riskScoreEntity === _search_strategy.RiskScoreEntity.user ? _constants.RISKY_USERS_DOC_LINK : _constants.RISKY_HOSTS_DOC_LINK;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    target: "_blank",
    rel: "noopener nofollow noreferrer",
    href: docLink
  }, title ? title : _translations.LEARN_MORE);
};
const RiskScoreDocLink = /*#__PURE__*/_react.default.memo(RiskScoreDocLinkComponent);
exports.RiskScoreDocLink = RiskScoreDocLink;
RiskScoreDocLink.displayName = 'RiskScoreDocLink';