"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AuthenticationsUserTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _fp = require("lodash/fp");
var _reactRedux = require("react-redux");
var _authentications = require("../../../../common/search_strategy/security_solution/users/authentications");
var _paginated_table = require("../paginated_table");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("./helpers");
var _authentications2 = require("../../containers/authentications");
var _manage_query = require("../../../common/components/page/manage_query");
var _query_toggle = require("../../../common/containers/query_toggle");
var _use_selector = require("../../../common/hooks/use_selector");
var _store = require("../../users/store");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TABLE_QUERY_ID = 'authenticationsUsersTableQuery';
const AuthenticationsUserTableComponent = ({
  endDate,
  filterQuery,
  indexNames,
  skip,
  startDate,
  type,
  setQuery,
  deleteQuery,
  userName
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    toggleStatus
  } = (0, _query_toggle.useQueryToggle)(TABLE_QUERY_ID);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const getAuthenticationsSelector = (0, _react.useMemo)(() => _store.usersSelectors.authenticationsSelector(), []);
  const {
    activePage,
    limit
  } = (0, _use_selector.useDeepEqualSelector)(state => getAuthenticationsSelector(state));
  const [loading, {
    authentications,
    totalCount,
    pageInfo,
    loadPage,
    inspect,
    isInspected,
    refetch
  }] = (0, _authentications2.useAuthentications)({
    endDate,
    filterQuery,
    indexNames,
    skip: querySkip,
    startDate,
    activePage,
    limit,
    stackByField: userName ? _authentications.AuthStackByField.hostName : _authentications.AuthStackByField.userName
  });
  const columns = (0, _react.useMemo)(() => userName ? (0, _helpers.getUserDetailsAuthenticationColumns)() : (0, _helpers.getUsersPageAuthenticationColumns)(), [userName]);
  const updateLimitPagination = (0, _react.useCallback)(newLimit => dispatch(_store.usersActions.updateTableLimit({
    usersType: type,
    limit: newLimit,
    tableType: _store.usersModel.UsersTableType.authentications
  })), [type, dispatch]);
  const updateActivePage = (0, _react.useCallback)(newPage => dispatch(_store.usersActions.updateTableActivePage({
    activePage: newPage,
    usersType: type,
    tableType: _store.usersModel.UsersTableType.authentications
  })), [type, dispatch]);
  (0, _manage_query.useQueryInspector)({
    queryId: TABLE_QUERY_ID,
    loading,
    refetch,
    setQuery,
    deleteQuery,
    inspect
  });
  return /*#__PURE__*/_react.default.createElement(_paginated_table.PaginatedTable, {
    activePage: activePage,
    columns: columns,
    dataTestSubj: "table-users-authentications",
    headerCount: totalCount,
    headerTitle: i18n.AUTHENTICATIONS,
    headerUnit: userName ? i18n.HOSTS_UNIT(totalCount) : i18n.USERS_UNIT(totalCount),
    id: TABLE_QUERY_ID,
    isInspect: isInspected,
    itemsPerRow: _helpers.rowItems,
    limit: limit,
    loading: loading,
    loadPage: loadPage,
    pageOfItems: authentications,
    setQuerySkip: setQuerySkip,
    showMorePagesIndicator: (0, _fp.getOr)(false, 'showMorePagesIndicator', pageInfo),
    totalCount: (0, _fp.getOr)(50, 'fakeTotalCount', pageInfo),
    updateLimitPagination: updateLimitPagination,
    updateActivePage: updateActivePage
  });
};
AuthenticationsUserTableComponent.displayName = 'AuthenticationsUserTableComponent';
const AuthenticationsUserTable = /*#__PURE__*/_react.default.memo(AuthenticationsUserTableComponent);
exports.AuthenticationsUserTable = AuthenticationsUserTable;