"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedComments = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var i18n = _interopRequireWildcard(require("./translations"));
var _with_copy_to_clipboard = require("../../common/lib/clipboard/with_copy_to_clipboard");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Formats ExceptionItem.comments into EuiCommentList format
 *
 * @param comments ExceptionItem.comments
 */
const getFormattedComments = comments => comments.map(commentItem => ({
  username: commentItem.created_by,
  timestamp: (0, _moment.default)(commentItem.created_at).format('on MMM Do YYYY @ HH:mm:ss'),
  event: i18n.COMMENT_EVENT,
  timelineAvatar: /*#__PURE__*/_react.default.createElement(_eui.EuiAvatar, {
    size: "l",
    name: commentItem.created_by.toUpperCase()
  }),
  children: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, commentItem.comment),
  actions: /*#__PURE__*/_react.default.createElement(_with_copy_to_clipboard.WithCopyToClipboard, {
    "data-test-subj": "copy-to-clipboard",
    text: commentItem.comment,
    titleSummary: i18n.ADD_TO_CLIPBOARD
  })
}));
exports.getFormattedComments = getFormattedComments;