"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrailingBreadcrumbs = void 0;
var _constants = require("../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isListDetailPage = pathname => pathname.includes(_constants.EXCEPTIONS_PATH) && pathname.includes('/details');
const getTrailingBreadcrumbs = (params, getSecuritySolutionUrl) => {
  var _params$state;
  let breadcrumb = [];
  if (isListDetailPage(params.pathName) && (_params$state = params.state) !== null && _params$state !== void 0 && _params$state.listName) {
    breadcrumb = [...breadcrumb, {
      text: params.state.listName
    }];
  }
  return breadcrumb;
};
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;