"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.uploadSuccessMessage = exports.showMoreRules = exports.referenceErrorMessage = exports.getSuccessText = exports.exceptionDeleteSuccessMessage = exports.defaultDeleteListMessage = exports.allExceptionsRowPerPage = exports.UPLOAD_SUCCESS_TITLE = exports.UPLOAD_ERROR = exports.UPLOAD_BUTTON = exports.SUCCESS_TITLE = exports.SORT_BY_CREATE_AT = exports.SORT_BY = exports.SHOWING_EXCEPTION_LISTS = exports.RULES_ASSIGNED_TO_TITLE = exports.RULES = exports.REFRESH_EXCEPTIONS_TABLE = exports.REFERENCE_MODAL_TITLE = exports.REFERENCE_MODAL_CONFIRM_BUTTON = exports.REFERENCE_MODAL_CANCEL_BUTTON = exports.READ_ONLY_BADGE_TOOLTIP = exports.NO_LISTS_BODY = exports.NO_EXCEPTION_LISTS = exports.LIST_DATE_UPDATED_TITLE = exports.LIST_DATE_CREATED_TITLE = exports.IMPORT_PROMPT = exports.IMPORT_EXCEPTION_LIST_WARNING = exports.IMPORT_EXCEPTION_LIST_OVERWRITE = exports.IMPORT_EXCEPTION_LIST_HEADER = exports.IMPORT_EXCEPTION_LIST_BUTTON = exports.IMPORT_EXCEPTION_LIST_BODY = exports.IMPORT_EXCEPTION_LIST_AS_NEW_LIST = exports.EXPIRED_EXCEPTIONS_MODAL_INCLUDE_SWITCH_LABEL = exports.EXPIRED_EXCEPTIONS_MODAL_EXPORT_TITLE = exports.EXPIRED_EXCEPTIONS_MODAL_EXPORT_DESCRIPTION = exports.EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_TITLE = exports.EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_DESCRIPTION = exports.EXPIRED_EXCEPTIONS_MODAL_CONFIRM_EXPORT_BUTTON = exports.EXPIRED_EXCEPTIONS_MODAL_CONFIRM_DUPLICATE_BUTTON = exports.EXPIRED_EXCEPTIONS_MODAL_CANCEL_BUTTON = exports.EXCEPTION_LIST_SEARCH_PLACEHOLDER = exports.EXCEPTION_LIST_NAME = exports.EXCEPTION_LIST_ID_TITLE = exports.EXCEPTION_LIST_EXPORTED_SUCCESSFULLY = exports.EXCEPTION_LIST_DUPLICATED_SUCCESSFULLY = exports.EXCEPTION_LIST_ACTIONS = exports.EXCEPTION_EXPORT_ERROR = exports.EXCEPTION_DUPLICATE_ERROR = exports.EXCEPTION_DELETE_ERROR = exports.EXCEPTIONS_LISTS_SEARCH_PLACEHOLDER = exports.EXCEPTIONS = exports.ERROR_EXCEPTION_LISTS = exports.DATE_CREATED = exports.CREATE_SHARED_LIST_TITLE = exports.CREATE_SHARED_LIST_NAME_FIELD_PLACEHOLDER = exports.CREATE_SHARED_LIST_NAME_FIELD = exports.CREATE_SHARED_LIST_DESCRIPTION_PLACEHOLDER = exports.CREATE_SHARED_LIST_DESCRIPTION = exports.CREATE_SHARED_LIST_BUTTON = exports.CREATE_BUTTON_ITEM_BUTTON = exports.CREATE_BUTTON = exports.CREATED_BY = exports.CLOSE_FLYOUT = exports.ALL_EXCEPTIONS_SUBTITLE = exports.ALL_EXCEPTIONS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXCEPTION_LIST_ID_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.idTitle', {
  defaultMessage: 'List ID'
});
exports.EXCEPTION_LIST_ID_TITLE = EXCEPTION_LIST_ID_TITLE;
const EXCEPTION_LIST_NAME = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.listName', {
  defaultMessage: 'Name'
});
exports.EXCEPTION_LIST_NAME = EXCEPTION_LIST_NAME;
const EXCEPTION_LIST_ACTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.actionsTitle', {
  defaultMessage: 'Actions'
});
exports.EXCEPTION_LIST_ACTIONS = EXCEPTION_LIST_ACTIONS;
const SHOWING_EXCEPTION_LISTS = totalLists => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.showingExceptionLists', {
  values: {
    totalLists
  },
  defaultMessage: 'Showing {totalLists} {totalLists, plural, =1 {list} other {lists}}'
});
exports.SHOWING_EXCEPTION_LISTS = SHOWING_EXCEPTION_LISTS;
const RULES_ASSIGNED_TO_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.rulesAssignedTitle', {
  defaultMessage: 'Rules assigned to'
});
exports.RULES_ASSIGNED_TO_TITLE = RULES_ASSIGNED_TO_TITLE;
const showMoreRules = rulesCount => _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.rulesPopoverButton', {
  defaultMessage: '+{rulesCount} {rulesCount, plural, =1 {Rule} other {Rules}}',
  values: {
    rulesCount
  }
});
exports.showMoreRules = showMoreRules;
const LIST_DATE_CREATED_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.dateCreatedTitle', {
  defaultMessage: 'Date created'
});
exports.LIST_DATE_CREATED_TITLE = LIST_DATE_CREATED_TITLE;
const LIST_DATE_UPDATED_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.dateUpdatedTitle', {
  defaultMessage: 'Last edited'
});
exports.LIST_DATE_UPDATED_TITLE = LIST_DATE_UPDATED_TITLE;
const ERROR_EXCEPTION_LISTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.errorFetching', {
  defaultMessage: 'Error fetching exception lists'
});
exports.ERROR_EXCEPTION_LISTS = ERROR_EXCEPTION_LISTS;
const NO_EXCEPTION_LISTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allExceptionLists.filters.noExceptionsTitle', {
  defaultMessage: 'No exception lists found'
});
exports.NO_EXCEPTION_LISTS = NO_EXCEPTION_LISTS;
const EXCEPTIONS_LISTS_SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allExceptionLists.search.placeholder', {
  defaultMessage: 'Search exception lists'
});
exports.EXCEPTIONS_LISTS_SEARCH_PLACEHOLDER = EXCEPTIONS_LISTS_SEARCH_PLACEHOLDER;
const ALL_EXCEPTIONS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allExceptions.tableTitle', {
  defaultMessage: 'Shared Exception Lists'
});
exports.ALL_EXCEPTIONS = ALL_EXCEPTIONS;
const ALL_EXCEPTIONS_SUBTITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allExceptions.tableSubtitle', {
  defaultMessage: "To view rule specific exceptions navigate to that rule's details page."
});
exports.ALL_EXCEPTIONS_SUBTITLE = ALL_EXCEPTIONS_SUBTITLE;
const allExceptionsRowPerPage = rowSize => _i18n.i18n.translate('xpack.securitySolution.exceptions.allExceptionsRowPerPage', {
  defaultMessage: 'Rows per page: {rowSize}',
  values: {
    rowSize
  }
});
exports.allExceptionsRowPerPage = allExceptionsRowPerPage;
const NO_LISTS_BODY = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.allExceptions.filters.noListsBody', {
  defaultMessage: "We weren't able to find any exception lists."
});
exports.NO_LISTS_BODY = NO_LISTS_BODY;
const EXCEPTION_LIST_EXPORTED_SUCCESSFULLY = listName => _i18n.i18n.translate('xpack.securitySolution.exceptions.list.export_success', {
  values: {
    listName
  },
  defaultMessage: 'Exception list "{listName}" exported successfully'
});
exports.EXCEPTION_LIST_EXPORTED_SUCCESSFULLY = EXCEPTION_LIST_EXPORTED_SUCCESSFULLY;
const EXCEPTION_EXPORT_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.exportError', {
  defaultMessage: 'Exception list export error'
});
exports.EXCEPTION_EXPORT_ERROR = EXCEPTION_EXPORT_ERROR;
const EXCEPTION_LIST_DUPLICATED_SUCCESSFULLY = listName => _i18n.i18n.translate('xpack.securitySolution.exceptions.list.duplicate_success', {
  values: {
    listName
  },
  defaultMessage: 'Exception list "{listName}" duplicated successfully'
});
exports.EXCEPTION_LIST_DUPLICATED_SUCCESSFULLY = EXCEPTION_LIST_DUPLICATED_SUCCESSFULLY;
const EXCEPTION_DUPLICATE_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.duplicateError', {
  defaultMessage: 'Exception list duplication error'
});
exports.EXCEPTION_DUPLICATE_ERROR = EXCEPTION_DUPLICATE_ERROR;
const EXCEPTION_DELETE_ERROR = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.deleteError', {
  defaultMessage: 'Error occurred deleting exception list'
});
exports.EXCEPTION_DELETE_ERROR = EXCEPTION_DELETE_ERROR;
const exceptionDeleteSuccessMessage = listId => _i18n.i18n.translate('xpack.securitySolution.exceptions.referenceModalSuccessDescription', {
  defaultMessage: 'Exception list - {listId} - deleted successfully.',
  values: {
    listId
  }
});
exports.exceptionDeleteSuccessMessage = exceptionDeleteSuccessMessage;
const REFERENCE_MODAL_TITLE = _i18n.i18n.translate('xpack.securitySolution.exceptions.referenceModalTitle', {
  defaultMessage: 'Remove exception list'
});
exports.REFERENCE_MODAL_TITLE = REFERENCE_MODAL_TITLE;
const defaultDeleteListMessage = listName => _i18n.i18n.translate('xpack.securitySolution.exceptions.referenceModalDefaultDescription', {
  defaultMessage: 'Are you sure you wish to DELETE exception list with the name {listName}?',
  values: {
    listName
  }
});
exports.defaultDeleteListMessage = defaultDeleteListMessage;
const REFERENCE_MODAL_CANCEL_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exceptions.referenceModalCancelButton', {
  defaultMessage: 'Cancel'
});
exports.REFERENCE_MODAL_CANCEL_BUTTON = REFERENCE_MODAL_CANCEL_BUTTON;
const REFERENCE_MODAL_CONFIRM_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exceptions.referenceModalDeleteButton', {
  defaultMessage: 'Remove exception list'
});
exports.REFERENCE_MODAL_CONFIRM_BUTTON = REFERENCE_MODAL_CONFIRM_BUTTON;
const referenceErrorMessage = referenceCount => _i18n.i18n.translate('xpack.securitySolution.exceptions.referenceModalDescription', {
  defaultMessage: 'This exception list is associated with ({referenceCount}) {referenceCount, plural, =1 {rule} other {rules}}. Removing this exception list will also remove its reference from the associated rules.',
  values: {
    referenceCount
  }
});
exports.referenceErrorMessage = referenceErrorMessage;
const EXCEPTION_LIST_SEARCH_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.searchPlaceholder', {
  defaultMessage: 'Search by name or list_id:id'
});
exports.EXCEPTION_LIST_SEARCH_PLACEHOLDER = EXCEPTION_LIST_SEARCH_PLACEHOLDER;
const REFRESH_EXCEPTIONS_TABLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.rules.all.exceptions.refresh', {
  defaultMessage: 'Refresh'
});
exports.REFRESH_EXCEPTIONS_TABLE = REFRESH_EXCEPTIONS_TABLE;
const UPLOAD_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exceptions.exceptionListsImportButton', {
  defaultMessage: 'Import list'
});
exports.UPLOAD_BUTTON = UPLOAD_BUTTON;
const uploadSuccessMessage = fileName => _i18n.i18n.translate('xpack.securitySolution.lists.exceptionListImportSuccess', {
  defaultMessage: 'Exception list {fileName} was imported',
  values: {
    fileName
  }
});
exports.uploadSuccessMessage = uploadSuccessMessage;
const UPLOAD_SUCCESS_TITLE = _i18n.i18n.translate('xpack.securitySolution.lists.exceptionListImportSuccessTitle', {
  defaultMessage: 'Exception list imported'
});
exports.UPLOAD_SUCCESS_TITLE = UPLOAD_SUCCESS_TITLE;
const UPLOAD_ERROR = _i18n.i18n.translate('xpack.securitySolution.lists.exceptionListUploadError', {
  defaultMessage: 'There was an error uploading the exception list.'
});
exports.UPLOAD_ERROR = UPLOAD_ERROR;
const IMPORT_EXCEPTION_LIST_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exceptions.manageExceptions.importExceptionList', {
  defaultMessage: 'Import exception list'
});
exports.IMPORT_EXCEPTION_LIST_BUTTON = IMPORT_EXCEPTION_LIST_BUTTON;
const IMPORT_EXCEPTION_LIST_HEADER = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.importExceptionListFlyoutHeader', {
  defaultMessage: 'Import shared exception list'
});
exports.IMPORT_EXCEPTION_LIST_HEADER = IMPORT_EXCEPTION_LIST_HEADER;
const IMPORT_EXCEPTION_LIST_BODY = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.importExceptionListFlyoutBody', {
  defaultMessage: 'Select shared exception lists to import'
});
exports.IMPORT_EXCEPTION_LIST_BODY = IMPORT_EXCEPTION_LIST_BODY;
const IMPORT_EXCEPTION_LIST_WARNING = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.importExceptionListWarning', {
  defaultMessage: 'We found a pre-existing list with that id'
});
exports.IMPORT_EXCEPTION_LIST_WARNING = IMPORT_EXCEPTION_LIST_WARNING;
const IMPORT_EXCEPTION_LIST_OVERWRITE = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.importExceptionListOverwrite', {
  defaultMessage: 'Overwrite the existing list'
});
exports.IMPORT_EXCEPTION_LIST_OVERWRITE = IMPORT_EXCEPTION_LIST_OVERWRITE;
const IMPORT_EXCEPTION_LIST_AS_NEW_LIST = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.importExceptionListAsNewList', {
  defaultMessage: 'Create new list'
});
exports.IMPORT_EXCEPTION_LIST_AS_NEW_LIST = IMPORT_EXCEPTION_LIST_AS_NEW_LIST;
const READ_ONLY_BADGE_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.exceptions.badge.readOnly.tooltip', {
  defaultMessage: 'Unable to create, edit or delete exceptions'
});
exports.READ_ONLY_BADGE_TOOLTIP = READ_ONLY_BADGE_TOOLTIP;
const CLOSE_FLYOUT = _i18n.i18n.translate('xpack.securitySolution.exceptions.exceptionListsCloseImportFlyout', {
  defaultMessage: 'Close'
});
exports.CLOSE_FLYOUT = CLOSE_FLYOUT;
const IMPORT_PROMPT = _i18n.i18n.translate('xpack.securitySolution.exceptions.exceptionListsFilePickerPrompt', {
  defaultMessage: 'Select or drag and drop multiple files'
});
exports.IMPORT_PROMPT = IMPORT_PROMPT;
const RULES = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.rulesCountLabel', {
  defaultMessage: 'Rules'
});
exports.RULES = RULES;
const CREATED_BY = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.createdBy', {
  defaultMessage: 'Created By'
});
exports.CREATED_BY = CREATED_BY;
const DATE_CREATED = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.createdAt', {
  defaultMessage: 'Date created'
});
exports.DATE_CREATED = DATE_CREATED;
const EXCEPTIONS = _i18n.i18n.translate('xpack.securitySolution.exceptionsTable.exceptionsCountLabel', {
  defaultMessage: 'Exceptions'
});
exports.EXCEPTIONS = EXCEPTIONS;
const CREATE_SHARED_LIST_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exceptions.manageExceptions.createSharedListButton', {
  defaultMessage: 'Create shared list'
});
exports.CREATE_SHARED_LIST_BUTTON = CREATE_SHARED_LIST_BUTTON;
const CREATE_BUTTON_ITEM_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exceptions.manageExceptions.createItemButton', {
  defaultMessage: 'Create exception item'
});
exports.CREATE_BUTTON_ITEM_BUTTON = CREATE_BUTTON_ITEM_BUTTON;
const CREATE_SHARED_LIST_TITLE = _i18n.i18n.translate('xpack.securitySolution.exceptions.createSharedExceptionListTitle', {
  defaultMessage: 'Create shared exception list'
});
exports.CREATE_SHARED_LIST_TITLE = CREATE_SHARED_LIST_TITLE;
const CREATE_SHARED_LIST_NAME_FIELD = _i18n.i18n.translate('xpack.securitySolution.exceptions.createSharedExceptionListFlyoutNameField', {
  defaultMessage: 'Shared exception list name'
});
exports.CREATE_SHARED_LIST_NAME_FIELD = CREATE_SHARED_LIST_NAME_FIELD;
const CREATE_SHARED_LIST_NAME_FIELD_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.exceptions.createSharedExceptionListFlyoutNameFieldPlaceholder', {
  defaultMessage: 'New exception list'
});
exports.CREATE_SHARED_LIST_NAME_FIELD_PLACEHOLDER = CREATE_SHARED_LIST_NAME_FIELD_PLACEHOLDER;
const CREATE_SHARED_LIST_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.exceptions.createSharedExceptionListFlyoutDescription', {
  defaultMessage: 'Description (optional)'
});
exports.CREATE_SHARED_LIST_DESCRIPTION = CREATE_SHARED_LIST_DESCRIPTION;
const CREATE_SHARED_LIST_DESCRIPTION_PLACEHOLDER = _i18n.i18n.translate('xpack.securitySolution.exceptions.createSharedExceptionListFlyoutDescriptionPlaceholder', {
  defaultMessage: 'New exception list description'
});
exports.CREATE_SHARED_LIST_DESCRIPTION_PLACEHOLDER = CREATE_SHARED_LIST_DESCRIPTION_PLACEHOLDER;
const CREATE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exceptions.createSharedExceptionListFlyoutCreateButton', {
  defaultMessage: 'Create shared exception list'
});
exports.CREATE_BUTTON = CREATE_BUTTON;
const getSuccessText = listName => _i18n.i18n.translate('xpack.securitySolution.exceptions.createSharedExceptionListSuccessDescription', {
  defaultMessage: 'List with name {listName} was created!',
  values: {
    listName
  }
});
exports.getSuccessText = getSuccessText;
const SUCCESS_TITLE = _i18n.i18n.translate('xpack.securitySolution.exceptions.createSharedExceptionListSuccessTitle', {
  defaultMessage: 'Created list'
});
exports.SUCCESS_TITLE = SUCCESS_TITLE;
const SORT_BY = _i18n.i18n.translate('xpack.securitySolution.exceptions.sortBy', {
  defaultMessage: 'Sort by:'
});
exports.SORT_BY = SORT_BY;
const SORT_BY_CREATE_AT = _i18n.i18n.translate('xpack.securitySolution.exceptions.sortByCreateAt', {
  defaultMessage: 'Created At'
});
exports.SORT_BY_CREATE_AT = SORT_BY_CREATE_AT;
const EXPIRED_EXCEPTIONS_MODAL_CANCEL_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exceptions.expiredExceptionModalCancelButton', {
  defaultMessage: 'Cancel'
});
exports.EXPIRED_EXCEPTIONS_MODAL_CANCEL_BUTTON = EXPIRED_EXCEPTIONS_MODAL_CANCEL_BUTTON;
const EXPIRED_EXCEPTIONS_MODAL_EXPORT_TITLE = _i18n.i18n.translate('xpack.securitySolution.exceptions.expiredExceptionModalExportTitle', {
  defaultMessage: 'Export exception list?'
});
exports.EXPIRED_EXCEPTIONS_MODAL_EXPORT_TITLE = EXPIRED_EXCEPTIONS_MODAL_EXPORT_TITLE;
const EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_TITLE = _i18n.i18n.translate('xpack.securitySolution.exceptions.expiredExceptionModalDuplicateTitle', {
  defaultMessage: 'Duplicate exception list?'
});
exports.EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_TITLE = EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_TITLE;
const EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.exceptions.expiredExceptionModalIncludeDuplicateDescription', {
  defaultMessage: 'You’re duplicating an exception list. Switch the toggle off to exclude expired exceptions.'
});
exports.EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_DESCRIPTION = EXPIRED_EXCEPTIONS_MODAL_DUPLICATE_DESCRIPTION;
const EXPIRED_EXCEPTIONS_MODAL_EXPORT_DESCRIPTION = _i18n.i18n.translate('xpack.securitySolution.exceptions.expiredExceptionModalIncludeExportDescription', {
  defaultMessage: 'You’re exporting an exception list. Switch the toggle off to exclude expired exceptions.'
});
exports.EXPIRED_EXCEPTIONS_MODAL_EXPORT_DESCRIPTION = EXPIRED_EXCEPTIONS_MODAL_EXPORT_DESCRIPTION;
const EXPIRED_EXCEPTIONS_MODAL_INCLUDE_SWITCH_LABEL = _i18n.i18n.translate('xpack.securitySolution.exceptions.expiredExceptionModalIncludeSwitchLabel', {
  defaultMessage: 'Include expired exceptions'
});
exports.EXPIRED_EXCEPTIONS_MODAL_INCLUDE_SWITCH_LABEL = EXPIRED_EXCEPTIONS_MODAL_INCLUDE_SWITCH_LABEL;
const EXPIRED_EXCEPTIONS_MODAL_CONFIRM_DUPLICATE_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exceptions.expiredExceptionModalConfirmDuplicateButton', {
  defaultMessage: 'Duplicate'
});
exports.EXPIRED_EXCEPTIONS_MODAL_CONFIRM_DUPLICATE_BUTTON = EXPIRED_EXCEPTIONS_MODAL_CONFIRM_DUPLICATE_BUTTON;
const EXPIRED_EXCEPTIONS_MODAL_CONFIRM_EXPORT_BUTTON = _i18n.i18n.translate('xpack.securitySolution.exceptions.expiredExceptionModalConfirmExportButton', {
  defaultMessage: 'Export'
});
exports.EXPIRED_EXCEPTIONS_MODAL_CONFIRM_EXPORT_BUTTON = EXPIRED_EXCEPTIONS_MODAL_CONFIRM_EXPORT_BUTTON;