"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListExceptionItems = void 0;
var _react = _interopRequireWildcard(require("react"));
var _securitysolutionExceptionListComponents = require("@kbn/securitysolution-exception-list-components");
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var _formatted_date = require("../../../common/components/formatted_date");
var _ui = require("../../utils/ui.helpers");
var _list_details_link_anchor = require("../list_details_link_anchor");
var _exceptions_utility = require("../exceptions_utility");
var i18n = _interopRequireWildcard(require("../../translations/list_exception_items"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ListExceptionItemsComponent = ({
  isReadOnly,
  exceptions,
  listType,
  lastUpdated,
  pagination,
  emptyViewerTitle,
  emptyViewerBody,
  emptyViewerButtonText,
  viewerStatus,
  ruleReferences,
  hideUtility = false,
  onDeleteException,
  onEditExceptionItem,
  onPaginationChange,
  onCreateExceptionListItem
}) => {
  const editButtonText = (0, _react.useMemo)(() => {
    return listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.EXCEPTION_ITEM_CARD_EDIT_ENDPOINT_LABEL : i18n.EXCEPTION_ITEM_CARD_EDIT_LABEL;
  }, [listType]);
  const deleteButtonText = (0, _react.useMemo)(() => {
    return listType === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.ENDPOINT ? i18n.EXCEPTION_ITEM_CARD_DELETE_ENDPOINT_LABEL : i18n.EXCEPTION_ITEM_CARD_DELETE_LABEL;
  }, [listType]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_securitysolutionExceptionListComponents.ExceptionItems, {
    viewerStatus: viewerStatus,
    listType: listType,
    ruleReferences: ruleReferences,
    isReadOnly: isReadOnly,
    exceptions: exceptions,
    emptyViewerTitle: emptyViewerTitle,
    emptyViewerBody: emptyViewerBody,
    emptyViewerButtonText: emptyViewerButtonText,
    pagination: pagination,
    lastUpdated: lastUpdated,
    editActionLabel: editButtonText,
    deleteActionLabel: deleteButtonText,
    onPaginationChange: onPaginationChange,
    onEditExceptionItem: onEditExceptionItem,
    onDeleteException: onDeleteException,
    getFormattedComments: _ui.getFormattedComments,
    securityLinkAnchorComponent: _list_details_link_anchor.ListDetailsLinkAnchor,
    formattedDateComponent: _formatted_date.FormattedDate,
    onCreateExceptionListItem: onCreateExceptionListItem,
    exceptionsUtilityComponent: () => hideUtility ? null : /*#__PURE__*/_react.default.createElement(_exceptions_utility.ExceptionsUtility, {
      exceptionsTitle: i18n.EXCEPTION_UTILITY_TITLE,
      pagination: pagination,
      lastUpdated: lastUpdated
    })
  }));
};
ListExceptionItemsComponent.displayName = 'ListExceptionItemsComponent';
const ListExceptionItems = /*#__PURE__*/_react.default.memo(ListExceptionItemsComponent);
exports.ListExceptionItems = ListExceptionItems;
ListExceptionItems.displayName = 'ListExceptionItems';