"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveFlyoutParams = void 0;
var _rison = require("@kbn/rison");
var _expandable_flyout_state_from_event_meta = require("../../../flyout/url/expandable_flyout_state_from_event_meta");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Resolves url parameters for the flyout, serialized as
 * rison string. NOTE: if user is already redirected to this route with flyout parameters set,
 * we simply use them. It will be the case when users are coming here using a link obtained
 * with Share Button on the Expandable Flyout
 */
const resolveFlyoutParams = ({
  index,
  alertId,
  isSecurityFlyoutEnabled
}, currentParamsString) => {
  if (!isSecurityFlyoutEnabled) {
    const legacyFlyoutString = (0, _rison.encode)({
      panelView: 'eventDetail',
      params: {
        eventId: alertId,
        indexName: index
      }
    });
    return legacyFlyoutString;
  }
  if (currentParamsString) {
    return currentParamsString;
  }
  const modernFlyoutString = (0, _rison.encode)((0, _expandable_flyout_state_from_event_meta.expandableFlyoutStateFromEventMeta)({
    index,
    eventId: alertId,
    scopeId: 'alerts-page'
  }));
  return modernFlyoutString;
};
exports.resolveFlyoutParams = resolveFlyoutParams;