"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getTrailingBreadcrumbs = void 0;
var _link_to = require("../../../../common/components/link_to");
var _constants = require("../../../../../common/constants");
var _types = require("../types");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TabNameMappedToI18nKey = {
  [_types.AlertDetailRouteType.summary]: i18n.SUMMARY_PAGE_TITLE
};
const getTrailingBreadcrumbs = (params, getSecuritySolutionUrl) => {
  let breadcrumb = [];
  if (params.detailName != null) {
    var _params$state$ruleNam, _params$state;
    breadcrumb = [...breadcrumb, {
      text: (_params$state$ruleNam = (_params$state = params.state) === null || _params$state === void 0 ? void 0 : _params$state.ruleName) !== null && _params$state$ruleNam !== void 0 ? _params$state$ruleNam : params.detailName,
      href: getSecuritySolutionUrl({
        path: (0, _link_to.getAlertDetailsUrl)(params.detailName, ''),
        deepLinkId: _constants.SecurityPageName.alerts
      })
    }];
  }
  if (params.tabName != null) {
    breadcrumb = [...breadcrumb, {
      text: TabNameMappedToI18nKey[params.tabName],
      href: ''
    }];
  }
  return breadcrumb;
};
exports.getTrailingBreadcrumbs = getTrailingBreadcrumbs;