"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertDetailsHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _formatted_date = require("../../../../common/components/formatted_date");
var _header_page = require("../../../../common/components/header_page");
var _translations = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AlertDetailsHeader = /*#__PURE__*/_react.default.memo(({
  loading,
  ruleName,
  timestamp
}) => {
  return /*#__PURE__*/_react.default.createElement(_header_page.HeaderPage, {
    badgeOptions: {
      beta: true,
      text: _translations.ALERT_DETAILS_TECHNICAL_PREVIEW
    },
    border: true,
    isLoading: loading,
    subtitle: timestamp ? /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
      value: new Date(timestamp)
    }) : '',
    title: ruleName
  });
});
exports.AlertDetailsHeader = AlertDetailsHeader;
AlertDetailsHeader.displayName = 'AlertDetailsHeader';