"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkAlertActionItems = void 0;
var _react = require("react");
var _esQuery = require("@kbn/es-query");
var _constants = require("../../../common/lib/apm/constants");
var _use_update_alerts = require("../../../common/components/toolbar/bulk_actions/use_update_alerts");
var _sourcerer = require("../../../common/containers/sourcerer");
var _use_app_toasts = require("../../../common/hooks/use_app_toasts");
var _use_start_transaction = require("../../../common/lib/apm/use_start_transaction");
var _types = require("../../../../common/types");
var i18n = _interopRequireWildcard(require("../translations"));
var _actions = require("../../components/alerts_table/actions");
var _helpers = require("../../components/alerts_table/helpers");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useBulkAlertActionItems = ({
  scopeId,
  filters,
  from,
  to,
  refetch: refetchProp
}) => {
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const {
    updateAlertStatus
  } = (0, _use_update_alerts.useUpdateAlertsStatus)();
  const {
    addSuccess,
    addError,
    addWarning
  } = (0, _use_app_toasts.useAppToasts)();
  const onAlertStatusUpdateSuccess = (0, _react.useCallback)((updated, conflicts, newStatus) => {
    if (conflicts > 0) {
      // Partial failure
      addWarning({
        title: i18n.UPDATE_ALERT_STATUS_FAILED(conflicts),
        text: i18n.UPDATE_ALERT_STATUS_FAILED_DETAILED(updated, conflicts)
      });
    } else {
      let title;
      switch (newStatus) {
        case 'closed':
          title = i18n.CLOSED_ALERT_SUCCESS_TOAST(updated);
          break;
        case 'open':
          title = i18n.OPENED_ALERT_SUCCESS_TOAST(updated);
          break;
        case 'acknowledged':
          title = i18n.ACKNOWLEDGED_ALERT_SUCCESS_TOAST(updated);
      }
      addSuccess({
        title
      });
    }
  }, [addSuccess, addWarning]);
  const onAlertStatusUpdateFailure = (0, _react.useCallback)((newStatus, error) => {
    let title;
    switch (newStatus) {
      case 'closed':
        title = i18n.CLOSED_ALERT_FAILED_TOAST;
        break;
      case 'open':
        title = i18n.OPENED_ALERT_FAILED_TOAST;
        break;
      case 'acknowledged':
        title = i18n.ACKNOWLEDGED_ALERT_FAILED_TOAST;
    }
    addError(error.message, {
      title
    });
  }, [addError]);
  const {
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)(scopeId);
  const getOnAction = (0, _react.useCallback)(status => {
    const onActionClick = async (items, isSelectAllChecked, setAlertLoading, clearSelection, refresh) => {
      const ids = items.map(item => item._id);
      let query = (0, _actions.getUpdateAlertsQuery)(ids).query;
      if (isSelectAllChecked) {
        const timeFilter = (0, _helpers.buildTimeRangeFilter)(from, to);
        query = (0, _esQuery.buildEsQuery)(undefined, [], [...timeFilter, ...filters], undefined);
      }
      if (query) {
        startTransaction({
          name: _constants.APM_USER_INTERACTIONS.BULK_QUERY_STATUS_UPDATE
        });
      } else if (items.length > 1) {
        startTransaction({
          name: _constants.APM_USER_INTERACTIONS.BULK_STATUS_UPDATE
        });
      } else {
        startTransaction({
          name: _constants.APM_USER_INTERACTIONS.STATUS_UPDATE
        });
      }
      try {
        var _response$updated, _response$version_con;
        setAlertLoading(true);
        const response = await updateAlertStatus({
          index: selectedPatterns.join(','),
          status,
          query
        });
        setAlertLoading(false);
        if (refetchProp) refetchProp();
        refresh();
        clearSelection();
        if (response.version_conflicts && items.length === 1) {
          throw new Error(i18n.BULK_ACTION_FAILED_SINGLE_ALERT);
        }
        onAlertStatusUpdateSuccess((_response$updated = response.updated) !== null && _response$updated !== void 0 ? _response$updated : 0, (_response$version_con = response.version_conflicts) !== null && _response$version_con !== void 0 ? _response$version_con : 0, status);
      } catch (error) {
        onAlertStatusUpdateFailure(status, error);
      }
    };
    return onActionClick;
  }, [onAlertStatusUpdateFailure, onAlertStatusUpdateSuccess, updateAlertStatus, selectedPatterns, startTransaction, filters, from, to, refetchProp]);
  const getUpdateAlertStatusAction = (0, _react.useCallback)(status => {
    const label = status === _types.FILTER_OPEN ? i18n.BULK_ACTION_OPEN_SELECTED : status === _types.FILTER_CLOSED ? i18n.BULK_ACTION_CLOSE_SELECTED : i18n.BULK_ACTION_ACKNOWLEDGED_SELECTED;
    return {
      label,
      key: `${status}-alert-status`,
      'data-test-subj': `${status}-alert-status`,
      disableOnQuery: false,
      onClick: getOnAction(status)
    };
  }, [getOnAction]);
  return [_types.FILTER_OPEN, _types.FILTER_CLOSED, _types.FILTER_ACKNOWLEDGED].map(status => getUpdateAlertStatusAction(status));
};
exports.useBulkAlertActionItems = useBulkAlertActionItems;