"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.listFormOptions = exports.ValueListsFormComponent = exports.ValueListsForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _securitysolutionListHooks = require("@kbn/securitysolution-list-hooks");
var i18n = _interopRequireWildcard(require("./translations"));
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const listFormOptions = [{
  value: 'keyword',
  text: i18n.KEYWORDS_RADIO
}, {
  value: 'ip',
  text: i18n.IP_RADIO
}, {
  value: 'ip_range',
  text: i18n.IP_RANGE_RADIO
}, {
  value: 'text',
  text: i18n.TEXT_RADIO
}];
exports.listFormOptions = listFormOptions;
const defaultListType = 'keyword';
const validFileTypes = ['text/csv', 'text/plain'];
const ValueListsFormComponent = ({
  onError,
  onSuccess
}) => {
  const ctrl = (0, _react.useRef)(new AbortController());
  const [file, setFile] = (0, _react.useState)(null);
  const [type, setType] = (0, _react.useState)(defaultListType);
  const filePickerRef = (0, _react.useRef)(null);
  const {
    http
  } = (0, _kibana.useKibana)().services;
  const {
    start: importList,
    ...importState
  } = (0, _securitysolutionListHooks.useImportList)();
  const fileIsValid = !file || validFileTypes.some(fileType => file.type === fileType);
  const handleRadioChange = (0, _react.useCallback)(event => setType(event.target.value), [setType]);
  const handleFileChange = (0, _react.useCallback)(files => {
    var _files$item;
    setFile((_files$item = files === null || files === void 0 ? void 0 : files.item(0)) !== null && _files$item !== void 0 ? _files$item : null);
  }, []);
  const resetForm = (0, _react.useCallback)(() => {
    var _filePickerRef$curren;
    if ((_filePickerRef$curren = filePickerRef.current) !== null && _filePickerRef$curren !== void 0 && _filePickerRef$curren.fileInput) {
      filePickerRef.current.fileInput.value = '';
      filePickerRef.current.handleChange();
    }
    setFile(null);
    setType(defaultListType);
  }, []);
  const handleCancel = (0, _react.useCallback)(() => {
    ctrl.current.abort();
  }, []);
  const handleSuccess = (0, _react.useCallback)(response => {
    resetForm();
    onSuccess(response);
  }, [resetForm, onSuccess]);
  const handleError = (0, _react.useCallback)(error => {
    onError(error);
  }, [onError]);
  const handleImport = (0, _react.useCallback)(() => {
    if (!importState.loading && file) {
      ctrl.current = new AbortController();
      importList({
        file,
        listId: undefined,
        http,
        signal: ctrl.current.signal,
        type
      });
    }
  }, [importState.loading, file, importList, http, type]);
  (0, _react.useEffect)(() => {
    if (!importState.loading && importState.result) {
      handleSuccess(importState.result);
    } else if (!importState.loading && importState.error) {
      handleError(importState.error);
    }
  }, [handleError, handleSuccess, importState.error, importState.loading, importState.result]);
  (0, _react.useEffect)(() => {
    return handleCancel;
  }, [handleCancel]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "value-list-file-picker-row",
    label: i18n.FILE_PICKER_LABEL,
    fullWidth: true,
    isInvalid: !fileIsValid,
    error: [i18n.FILE_PICKER_INVALID_FILE_TYPE(validFileTypes.join(', '))]
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilePicker, {
    accept: validFileTypes.join(),
    "data-test-subj": "value-list-file-picker",
    id: "value-list-file-picker",
    initialPromptText: i18n.FILE_PICKER_PROMPT,
    ref: filePickerRef,
    onChange: handleFileChange,
    fullWidth: true,
    isLoading: importState.loading,
    isInvalid: !fileIsValid
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.LIST_TYPES_RADIO_LABEL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    "data-test-subj": "value-lists-form-select-type-action",
    options: listFormOptions,
    value: type,
    onChange: handleRadioChange,
    name: "valueListType"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    hasEmptyLabelSpace: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, importState.loading && /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleCancel
  }, i18n.CANCEL_BUTTON)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "value-lists-form-import-action",
    onClick: handleImport,
    disabled: file == null || !fileIsValid || importState.loading
  }, i18n.UPLOAD_BUTTON))))))));
};
exports.ValueListsFormComponent = ValueListsFormComponent;
ValueListsFormComponent.displayName = 'ValueListsFormComponent';
const ValueListsForm = /*#__PURE__*/_react.default.memo(ValueListsFormComponent);
exports.ValueListsForm = ValueListsForm;
ValueListsForm.displayName = 'ValueListsForm';