"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduleItem = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _shared_imports = require("../../../../shared_imports");
var I18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const timeTypeOptions = [{
  value: 's',
  text: I18n.SECONDS
}, {
  value: 'm',
  text: I18n.MINUTES
}, {
  value: 'h',
  text: I18n.HOURS
}, {
  value: 'd',
  text: I18n.DAYS
}];

// move optional label to the end of input
const StyledLabelAppend = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  &.euiFlexItem {
    margin-left: 31px;
  }
`;
const StyledEuiFormRow = (0, _styledComponents.default)(_eui.EuiFormRow)`
  max-width: none;

  .euiFormControlLayout {
    max-width: auto;
    width: auto;
  }

  .euiFormControlLayout__childrenWrapper > *:first-child {
    box-shadow: none;
    height: 38px;
    width: 100%;
  }

  .euiFormControlLayout__childrenWrapper > select {
    background-color: ${({
  theme
}) => (0, _eui.transparentize)(theme.eui.euiColorPrimary, 0.1)};
    color: ${({
  theme
}) => theme.eui.euiColorPrimary};
  }

  .euiFormControlLayout--group .euiFormControlLayout {
    min-width: 100px;
  }

  .euiFormControlLayoutIcons {
    color: ${({
  theme
}) => theme.eui.euiColorPrimary};
  }

  .euiFormControlLayout:not(:first-child) {
    border-left: 1px solid ${({
  theme
}) => theme.eui.euiColorLightShade};
  }
`;
const MyEuiSelect = (0, _styledComponents.default)(_eui.EuiSelect)`
  width: auto;
`;
const getNumberFromUserInput = (input, minimumValue = 0) => {
  const number = parseInt(input, 10);
  if (Number.isNaN(number)) {
    return minimumValue;
  } else {
    return Math.max(minimumValue, Math.min(number, Number.MAX_SAFE_INTEGER));
  }
};
const ScheduleItem = ({
  dataTestSubj,
  field,
  idAria,
  isDisabled,
  minimumValue = 0,
  timeTypes = ['s', 'm', 'h'],
  fullWidth = false
}) => {
  const [timeType, setTimeType] = (0, _react.useState)(timeTypes[0]);
  const [timeVal, setTimeVal] = (0, _react.useState)(0);
  const {
    isInvalid,
    errorMessage
  } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
  const {
    value,
    setValue
  } = field;
  const onChangeTimeType = (0, _react.useCallback)(e => {
    setTimeType(e.target.value);
    setValue(`${timeVal}${e.target.value}`);
  }, [setValue, timeVal]);
  const onChangeTimeVal = (0, _react.useCallback)(e => {
    const sanitizedValue = getNumberFromUserInput(e.target.value, minimumValue);
    setTimeVal(sanitizedValue);
    setValue(`${sanitizedValue}${timeType}`);
  }, [minimumValue, setValue, timeType]);
  (0, _react.useEffect)(() => {
    if (value !== `${timeVal}${timeType}`) {
      const filterTimeVal = value.match(/\d+/g);
      const filterTimeType = value.match(/[a-zA-Z]+/g);
      if (!(0, _fp.isEmpty)(filterTimeVal) && filterTimeVal != null && !isNaN(Number(filterTimeVal[0])) && Number(filterTimeVal[0]) !== Number(timeVal)) {
        setTimeVal(Number(filterTimeVal[0]));
      }
      if (!(0, _fp.isEmpty)(filterTimeType) && filterTimeType != null && timeTypes.includes(filterTimeType[0]) && filterTimeType[0] !== timeType) {
        setTimeType(filterTimeType[0]);
      }
    }
  }, [timeType, timeTypes, timeVal, value]);

  // EUI missing some props
  const rest = {
    disabled: isDisabled
  };
  const label = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    justifyContent: "flexStart",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    component: "span"
  }, field.label), /*#__PURE__*/_react.default.createElement(StyledLabelAppend, {
    grow: false,
    component: "span"
  }, field.labelAppend)), [field.label, field.labelAppend]);
  return /*#__PURE__*/_react.default.createElement(StyledEuiFormRow, {
    label: label,
    helpText: field.helpText,
    error: errorMessage,
    isInvalid: isInvalid,
    fullWidth: fullWidth,
    "data-test-subj": dataTestSubj,
    describedByIds: idAria ? [idAria] : undefined
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormControlLayout, {
    append: /*#__PURE__*/_react.default.createElement(MyEuiSelect, (0, _extends2.default)({
      fullWidth: false,
      options: timeTypeOptions.filter(type => timeTypes.includes(type.value)),
      onChange: onChangeTimeType,
      value: timeType,
      "data-test-subj": "timeType"
    }, rest))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, (0, _extends2.default)({
    fullWidth: true,
    min: minimumValue,
    max: Number.MAX_SAFE_INTEGER,
    onChange: onChangeTimeVal,
    value: timeVal,
    "data-test-subj": "interval"
  }, rest))));
};
exports.ScheduleItem = ScheduleItem;