"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulePreview = exports.REASONABLE_INVOCATION_COUNT = void 0;
var _react = _interopRequireWildcard(require("react"));
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _eui = require("@elastic/eui");
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_preview_route = require("./use_preview_route");
var _preview_histogram = require("./preview_histogram");
var _preview_logs = require("./preview_logs");
var _kibana = require("../../../../common/lib/kibana");
var _loading_histogram = require("./loading_histogram");
var _use_start_transaction = require("../../../../common/lib/apm/use_start_transaction");
var _user_actions = require("../../../../common/lib/apm/user_actions");
var _use_preview_invocation_count = require("./use_preview_invocation_count");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const REASONABLE_INVOCATION_COUNT = 200;
exports.REASONABLE_INVOCATION_COUNT = REASONABLE_INVOCATION_COUNT;
const timeRanges = [{
  start: 'now/d',
  end: 'now',
  label: 'Today'
}, {
  start: 'now/w',
  end: 'now',
  label: 'This week'
}, {
  start: 'now-15m',
  end: 'now',
  label: 'Last 15 minutes'
}, {
  start: 'now-30m',
  end: 'now',
  label: 'Last 30 minutes'
}, {
  start: 'now-1h',
  end: 'now',
  label: 'Last 1 hour'
}, {
  start: 'now-24h',
  end: 'now',
  label: 'Last 24 hours'
}, {
  start: 'now-7d',
  end: 'now',
  label: 'Last 7 days'
}, {
  start: 'now-30d',
  end: 'now',
  label: 'Last 30 days'
}];
const refreshedTimeframe = (startDate, endDate) => {
  return {
    start: _datemath.default.parse(startDate) || (0, _moment.default)().subtract(1, 'hour'),
    end: _datemath.default.parse(endDate) || (0, _moment.default)()
  };
};
const RulePreviewComponent = ({
  isDisabled,
  defineRuleData,
  aboutRuleData,
  scheduleRuleData,
  exceptionsList
}) => {
  const {
    indexPattern,
    ruleType
  } = defineRuleData;
  const {
    spaces
  } = (0, _kibana.useKibana)().services;
  const [spaceId, setSpaceId] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (spaces) {
      spaces.getActiveSpace().then(space => setSpaceId(space.id));
    }
  }, [spaces]);

  // Raw timeframe as a string
  const [startDate, setStartDate] = (0, _react.useState)('now-1h');
  const [endDate, setEndDate] = (0, _react.useState)('now');

  // Parsed timeframe as a Moment object
  const [timeframeStart, setTimeframeStart] = (0, _react.useState)((0, _moment.default)().subtract(1, 'hour'));
  const [timeframeEnd, setTimeframeEnd] = (0, _react.useState)((0, _moment.default)());
  const [isDateRangeInvalid, setIsDateRangeInvalid] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    const {
      start,
      end
    } = refreshedTimeframe(startDate, endDate);
    setTimeframeStart(start);
    setTimeframeEnd(end);
  }, [startDate, endDate]);

  // The data state that we used for the last preview results
  const [previewData, setPreviewData] = (0, _react.useState)({
    timeframeOptions: {
      timeframeStart,
      timeframeEnd,
      interval: '5m',
      lookback: '1m'
    }
  });
  const {
    invocationCount
  } = (0, _use_preview_invocation_count.usePreviewInvocationCount)({
    timeframeOptions: {
      timeframeStart,
      timeframeEnd,
      interval: scheduleRuleData.interval,
      lookback: scheduleRuleData.from
    }
  });
  const showInvocationCountWarning = invocationCount > REASONABLE_INVOCATION_COUNT;
  const {
    addNoiseWarning,
    createPreview,
    isPreviewRequestInProgress,
    previewId,
    logs,
    hasNoiseWarning,
    isAborted
  } = (0, _use_preview_route.usePreviewRoute)({
    defineRuleData: previewData.defineRuleData,
    aboutRuleData: previewData.aboutRuleData,
    scheduleRuleData: previewData.scheduleRuleData,
    exceptionsList,
    timeframeOptions: previewData.timeframeOptions
  });
  const {
    startTransaction
  } = (0, _use_start_transaction.useStartTransaction)();
  const [isRefreshing, setIsRefreshing] = (0, _react.useState)(false);
  (0, _react.useEffect)(() => {
    if (!isRefreshing) {
      return;
    }
    createPreview();
    setIsRefreshing(false);
  }, [isRefreshing, createPreview]);
  (0, _react.useEffect)(() => {
    const {
      start,
      end
    } = refreshedTimeframe(startDate, endDate);
    setTimeframeStart(start);
    setTimeframeEnd(end);
  }, [endDate, startDate]);
  const onTimeChange = (0, _react.useCallback)(({
    start: newStart,
    end: newEnd,
    isInvalid
  }) => {
    setIsDateRangeInvalid(isInvalid);
    if (!isInvalid) {
      setStartDate(newStart);
      setEndDate(newEnd);
    }
  }, []);
  const onTimeframeRefresh = (0, _react.useCallback)(() => {
    startTransaction({
      name: _user_actions.SINGLE_RULE_ACTIONS.PREVIEW
    });
    const {
      start,
      end
    } = refreshedTimeframe(startDate, endDate);
    setTimeframeStart(start);
    setTimeframeEnd(end);
    setPreviewData({
      defineRuleData,
      aboutRuleData,
      scheduleRuleData,
      timeframeOptions: {
        timeframeStart: start,
        timeframeEnd: end,
        interval: scheduleRuleData.interval,
        lookback: scheduleRuleData.from
      }
    });
    setIsRefreshing(true);
  }, [aboutRuleData, defineRuleData, endDate, scheduleRuleData, startDate, startTransaction]);
  const isDirty = (0, _react.useMemo)(() => !timeframeStart.isSame(previewData.timeframeOptions.timeframeStart) || !timeframeEnd.isSame(previewData.timeframeOptions.timeframeEnd) || !(0, _lodash.isEqual)(defineRuleData, previewData.defineRuleData) || !(0, _lodash.isEqual)(aboutRuleData, previewData.aboutRuleData) || !(0, _lodash.isEqual)(scheduleRuleData, previewData.scheduleRuleData), [aboutRuleData, defineRuleData, previewData.aboutRuleData, previewData.defineRuleData, previewData.scheduleRuleData, previewData.timeframeOptions.timeframeEnd, previewData.timeframeOptions.timeframeStart, scheduleRuleData, timeframeEnd, timeframeStart]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", null, i18n.RULE_PREVIEW_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("p", null, i18n.RULE_PREVIEW_DESCRIPTION)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), showInvocationCountWarning && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    title: i18n.QUERY_PREVIEW_INVOCATION_COUNT_WARNING_TITLE,
    "data-test-subj": "previewInvocationCountWarning"
  }, i18n.QUERY_PREVIEW_INVOCATION_COUNT_WARNING_MESSAGE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: i18n.QUERY_PREVIEW_LABEL,
    error: undefined,
    isInvalid: false,
    "data-test-subj": "rule-preview",
    describedByIds: ['rule-preview']
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    responsive: false,
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperDatePicker, {
    start: startDate,
    end: endDate,
    isDisabled: isDisabled,
    onTimeChange: onTimeChange,
    showUpdateButton: false,
    commonlyUsedRanges: timeRanges,
    onRefresh: onTimeframeRefresh,
    "data-test-subj": "preview-time-frame"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperUpdateButton, {
    isDisabled: isDateRangeInvalid || isDisabled,
    iconType: isDirty ? 'kqlFunction' : 'refresh',
    onClick: onTimeframeRefresh,
    color: isDirty ? 'success' : 'primary',
    fill: true,
    "data-test-subj": "previewSubmitButton"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), isPreviewRequestInProgress && /*#__PURE__*/_react.default.createElement(_loading_histogram.LoadingHistogram, null), !isPreviewRequestInProgress && previewId && spaceId && /*#__PURE__*/_react.default.createElement(_preview_histogram.PreviewHistogram, {
    ruleType: ruleType,
    previewId: previewId,
    addNoiseWarning: addNoiseWarning,
    spaceId: spaceId,
    indexPattern: indexPattern,
    timeframeOptions: previewData.timeframeOptions
  }), /*#__PURE__*/_react.default.createElement(_preview_logs.PreviewLogsComponent, {
    logs: logs,
    hasNoiseWarning: hasNoiseWarning,
    isAborted: isAborted
  }));
};
const RulePreview = /*#__PURE__*/_react.default.memo(RulePreviewComponent);
exports.RulePreview = RulePreview;