"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlAuditIcon = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var MessageLevels;
(function (MessageLevels) {
  MessageLevels["info"] = "info";
  MessageLevels["warning"] = "warning";
  MessageLevels["error"] = "error";
})(MessageLevels || (MessageLevels = {}));
const MlAuditIconComponent = ({
  message
}) => {
  if (!message) {
    return null;
  }
  let color = 'primary';
  let icon = 'warning';
  if (message.level === MessageLevels.info) {
    icon = 'iInCircle';
  } else if (message.level === MessageLevels.warning) {
    color = 'warning';
  } else if (message.level === MessageLevels.error) {
    color = 'danger';
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: message.text
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    "data-test-subj": "mlJobAuditIcon",
    type: icon,
    color: color
  }));
};
const MlAuditIcon = /*#__PURE__*/(0, _react.memo)(MlAuditIconComponent);
exports.MlAuditIcon = MlAuditIcon;