"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccordionTitle = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _status_icon = require("../status_icon");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AccordionTitleComponent = ({
  name,
  title,
  type
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "m",
  responsive: false
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_status_icon.RuleStatusIcon, {
  name: name,
  type: type
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "s",
  className: "euiAccordionForm__title"
}, /*#__PURE__*/_react.default.createElement("h6", null, title))));
const AccordionTitle = /*#__PURE__*/_react.default.memo(AccordionTitleComponent);
exports.AccordionTitle = AccordionTitle;