"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNISOLATE_HOST = exports.RETURN_TO_ALERT_DETAILS = exports.ISOLATE_HOST = exports.CASES_ASSOCIATED_WITH_ALERT = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ISOLATE_HOST = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.isolateHost', {
  defaultMessage: 'Isolate host'
});
exports.ISOLATE_HOST = ISOLATE_HOST;
const UNISOLATE_HOST = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.unisolateHost', {
  defaultMessage: 'Release host'
});
exports.UNISOLATE_HOST = UNISOLATE_HOST;
const CASES_ASSOCIATED_WITH_ALERT = caseCount => _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.isolateHost.casesAssociatedWithAlert', {
  defaultMessage: '{caseCount} {caseCount, plural, one {case} other {cases}} associated with this host',
  values: {
    caseCount
  }
});
exports.CASES_ASSOCIATED_WITH_ALERT = CASES_ASSOCIATED_WITH_ALERT;
const RETURN_TO_ALERT_DETAILS = _i18n.i18n.translate('xpack.securitySolution.endpoint.hostIsolation.returnToAlertDetails', {
  defaultMessage: 'Return to alert details'
});
exports.RETURN_TO_ALERT_DETAILS = RETURN_TO_ALERT_DETAILS;