"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.missingPrivilegesCallOutBody = exports.MISSING_PRIVILEGES_CALLOUT_TITLE = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../../../../../common/constants");
var _comma_separated_values = require("./comma_separated_values");
var _links_to_docs = require("../../../../common/components/links_to_docs");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MISSING_PRIVILEGES_CALLOUT_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.missingPrivilegesCallOut.messageTitle', {
  defaultMessage: 'Insufficient privileges'
});
exports.MISSING_PRIVILEGES_CALLOUT_TITLE = MISSING_PRIVILEGES_CALLOUT_TITLE;
const CANNOT_EDIT_RULES = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.missingPrivilegesCallOut.cannotEditRules', {
  defaultMessage: 'Without that privilege you cannot create or edit detection engine rules.'
});
const CANNOT_EDIT_LISTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.missingPrivilegesCallOut.cannotEditLists', {
  defaultMessage: 'Without these privileges, you cannot create or edit value lists.'
});
const CANNOT_EDIT_ALERTS = _i18n.i18n.translate('xpack.securitySolution.detectionEngine.missingPrivilegesCallOut.cannotEditAlerts', {
  defaultMessage: 'Without these privileges, you cannot view or change status of alerts.'
});
const missingPrivilegesCallOutBody = ({
  indexPrivileges,
  featurePrivileges = []
}) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.missingPrivilegesCallOut.messageBody.messageDetail",
  defaultMessage: "{essence} {indexPrivileges} {featurePrivileges} Related documentation: {docs}",
  values: {
    essence: /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.missingPrivilegesCallOut.messageBody.essenceDescription",
      defaultMessage: "You need the following privileges to fully access this functionality. Contact your administrator for further assistance."
    })),
    indexPrivileges: indexPrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.missingPrivilegesCallOut.messageBody.indexPrivilegesTitle",
      defaultMessage: "Missing Elasticsearch index privileges:"
    }), /*#__PURE__*/_react.default.createElement("ul", null, indexPrivileges.map(([index, missingPrivileges]) => /*#__PURE__*/_react.default.createElement("li", {
      key: index
    }, missingIndexPrivileges(index, missingPrivileges))))) : null,
    featurePrivileges: featurePrivileges.length > 0 ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.detectionEngine.missingPrivilegesCallOut.messageBody.featurePrivilegesTitle",
      defaultMessage: "Missing Kibana feature privileges:"
    }), /*#__PURE__*/_react.default.createElement("ul", null, featurePrivileges.map(([feature, missingPrivileges]) => /*#__PURE__*/_react.default.createElement("li", {
      key: feature
    }, missingFeaturePrivileges(feature, missingPrivileges))))) : null,
    docs: /*#__PURE__*/_react.default.createElement("ul", null, /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_links_to_docs.DetectionsRequirementsLink, null)), /*#__PURE__*/_react.default.createElement("li", null, /*#__PURE__*/_react.default.createElement(_links_to_docs.SecuritySolutionRequirementsLink, null)))
  }
});
exports.missingPrivilegesCallOutBody = missingPrivilegesCallOutBody;
const PRIVILEGE_EXPLANATIONS = {
  [_constants.SECURITY_FEATURE_ID]: {
    all: CANNOT_EDIT_RULES
  },
  [_constants.DEFAULT_SIGNALS_INDEX]: {
    write: CANNOT_EDIT_ALERTS
  },
  [_constants.DEFAULT_LISTS_INDEX]: {
    write: CANNOT_EDIT_LISTS
  },
  [_constants.DEFAULT_ITEMS_INDEX]: {
    write: CANNOT_EDIT_LISTS
  }
};
const getPrivilegesExplanation = (missingPrivileges, index) => {
  var _Object$entries$find;
  const explanationsByPrivilege = (_Object$entries$find = Object.entries(PRIVILEGE_EXPLANATIONS).find(([key]) => index.startsWith(key))) === null || _Object$entries$find === void 0 ? void 0 : _Object$entries$find[1];
  return missingPrivileges.map(privilege => explanationsByPrivilege === null || explanationsByPrivilege === void 0 ? void 0 : explanationsByPrivilege[privilege]).filter(Boolean).join(' ');
};
const missingIndexPrivileges = (index, privileges) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.missingPrivilegesCallOut.messageBody.missingIndexPrivileges",
  defaultMessage: "Missing {privileges} privileges for the {index} index. {explanation}",
  values: {
    privileges: /*#__PURE__*/_react.default.createElement(_comma_separated_values.CommaSeparatedValues, {
      values: privileges
    }),
    index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, index),
    explanation: getPrivilegesExplanation(privileges, index)
  }
});
const missingFeaturePrivileges = (feature, privileges) => /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.securitySolution.detectionEngine.missingPrivilegesCallOut.messageBody.missingFeaturePrivileges",
  defaultMessage: "Missing {privileges} privileges for the {index} feature. {explanation}",
  values: {
    privileges: /*#__PURE__*/_react.default.createElement(_comma_separated_values.CommaSeparatedValues, {
      values: privileges
    }),
    index: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, feature),
    explanation: getPrivilegesExplanation(privileges, feature)
  }
});