"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseSeverityData = exports.getSeverityColor = exports.getIsAlertsBySeverityData = exports.getIsAlertsBySeverityAgg = void 0;
var _lodash = require("lodash");
var _use_alerts_by_status = require("../../../../overview/components/detection_response/alerts_by_status/use_alerts_by_status");
var _donutchart_empty = require("../../../../common/components/charts/donutchart_empty");
var _utils = require("../../../../overview/components/detection_response/utils");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getSeverityColor = severity => {
  var _SEVERITY_COLOR;
  return (_SEVERITY_COLOR = _utils.SEVERITY_COLOR[severity.toLocaleLowerCase()]) !== null && _SEVERITY_COLOR !== void 0 ? _SEVERITY_COLOR : _donutchart_empty.emptyDonutColor;
};
exports.getSeverityColor = getSeverityColor;
const parseSeverityData = response => {
  var _response$aggregation, _response$aggregation2, _response$aggregation3;
  const severityBuckets = (_response$aggregation = response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.statusBySeverity) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.buckets) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
  return severityBuckets.length === 0 ? [] : severityBuckets.map(severity => {
    var _severityLabels$sever;
    return {
      key: severity.key,
      value: severity.doc_count,
      label: (_severityLabels$sever = _use_alerts_by_status.severityLabels[severity.key]) !== null && _severityLabels$sever !== void 0 ? _severityLabels$sever : i18n.UNKNOWN_SEVERITY
    };
  });
};
exports.parseSeverityData = parseSeverityData;
const getIsAlertsBySeverityData = data => {
  return data === null || data === void 0 ? void 0 : data.every(x => (0, _lodash.has)(x, 'key'));
};
exports.getIsAlertsBySeverityData = getIsAlertsBySeverityData;
const getIsAlertsBySeverityAgg = data => {
  return (0, _lodash.has)(data, 'aggregations.statusBySeverity');
};
exports.getIsAlertsBySeverityAgg = getIsAlertsBySeverityAgg;