"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAggregatableFields = getAggregatableFields;
exports.isDataViewFieldSubtypeNested = isDataViewFieldSubtypeNested;
exports.isLensSupportedType = isLensSupportedType;
exports.useStackByFields = exports.useInspectButton = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _source = require("../../../../common/containers/source");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * * Add query to inspect button utility.
 * * Delete query from inspect button utility when component unmounts
 */
const useInspectButton = ({
  setQuery,
  response,
  request,
  refetch,
  uniqueQueryId,
  deleteQuery,
  loading,
  searchSessionId
}) => {
  (0, _react.useEffect)(() => {
    if (refetch != null && setQuery != null) {
      setQuery({
        id: uniqueQueryId,
        inspect: {
          dsl: [request],
          response: [response]
        },
        loading,
        refetch,
        searchSessionId
      });
    }
    return () => {
      if (deleteQuery) {
        deleteQuery({
          id: uniqueQueryId
        });
      }
    };
  }, [setQuery, loading, response, request, refetch, uniqueQueryId, deleteQuery, searchSessionId]);
};
exports.useInspectButton = useInspectButton;
function isDataViewFieldSubtypeNested(field) {
  var _subTypeNested$nested;
  const subTypeNested = field === null || field === void 0 ? void 0 : field.subType;
  return !!(subTypeNested !== null && subTypeNested !== void 0 && (_subTypeNested$nested = subTypeNested.nested) !== null && _subTypeNested$nested !== void 0 && _subTypeNested$nested.path);
}
function isLensSupportedType(fieldType) {
  const supportedTypes = new Set(['string', 'boolean', 'number', 'ip']);
  return fieldType ? supportedTypes.has(fieldType) : false;
}
function getAggregatableFields(fields, useLensCompatibleFields) {
  const result = [];
  for (const [key, field] of Object.entries(fields)) {
    if (useLensCompatibleFields) {
      if (!!field.aggregatable && isLensSupportedType(field.type) && !isDataViewFieldSubtypeNested(field)) {
        result.push({
          label: key,
          value: key
        });
      }
    } else {
      if (field.aggregatable === true) {
        result.push({
          label: key,
          value: key
        });
      }
    }
  }
  return result;
}
const useStackByFields = useLensCompatibleFields => {
  const {
    pathname
  } = (0, _reactRouterDom.useLocation)();
  const {
    browserFields
  } = (0, _sourcerer.useSourcererDataView)((0, _sourcerer.getScopeFromPath)(pathname));
  const allFields = (0, _react.useMemo)(() => (0, _source.getAllFieldsByName)(browserFields), [browserFields]);
  const [stackByFieldOptions, setStackByFieldOptions] = (0, _react.useState)(() => getAggregatableFields(allFields, useLensCompatibleFields));
  (0, _react.useEffect)(() => {
    setStackByFieldOptions(getAggregatableFields(allFields, useLensCompatibleFields));
  }, [allFields, useLensCompatibleFields]);
  return (0, _react.useMemo)(() => stackByFieldOptions, [stackByFieldOptions]);
};
exports.useStackByFields = useStackByFields;