"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.parseAlertsGroupingData = exports.getNonEmptyPercent = exports.getIsAlertsProgressBarData = exports.getIsAlertsByGroupingAgg = exports.getGroupByLabel = void 0;
var _lodash = require("lodash");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const parseAlertsGroupingData = response => {
  var _response$aggregation, _response$aggregation2, _response$aggregation3, _response$aggregation4, _response$aggregation5, _response$aggregation6, _response$aggregation7, _response$aggregation8, _response$aggregation9;
  const buckets = (_response$aggregation = response === null || response === void 0 ? void 0 : (_response$aggregation2 = response.aggregations) === null || _response$aggregation2 === void 0 ? void 0 : (_response$aggregation3 = _response$aggregation2.alertsByGrouping) === null || _response$aggregation3 === void 0 ? void 0 : _response$aggregation3.buckets) !== null && _response$aggregation !== void 0 ? _response$aggregation : [];
  const emptyFieldCount = (_response$aggregation4 = response === null || response === void 0 ? void 0 : (_response$aggregation5 = response.aggregations) === null || _response$aggregation5 === void 0 ? void 0 : (_response$aggregation6 = _response$aggregation5.missingFields) === null || _response$aggregation6 === void 0 ? void 0 : _response$aggregation6.doc_count) !== null && _response$aggregation4 !== void 0 ? _response$aggregation4 : 0;
  if (buckets.length === 0 && emptyFieldCount === 0) {
    return [];
  }
  const other = (_response$aggregation7 = response === null || response === void 0 ? void 0 : (_response$aggregation8 = response.aggregations) === null || _response$aggregation8 === void 0 ? void 0 : (_response$aggregation9 = _response$aggregation8.alertsByGrouping) === null || _response$aggregation9 === void 0 ? void 0 : _response$aggregation9.sum_other_doc_count) !== null && _response$aggregation7 !== void 0 ? _response$aggregation7 : 0;
  const total = buckets.reduce((acc, group) => acc + group.doc_count, 0) + other + emptyFieldCount;
  const topAlerts = buckets.map(group => {
    return {
      key: group.key,
      value: group.doc_count,
      percentage: Math.round(group.doc_count / total * 1000) / 10,
      label: group.key
    };
  });
  if (other > 0) {
    topAlerts.push({
      key: 'Other',
      value: other,
      percentage: Math.round(other / total * 1000) / 10,
      label: i18n.OTHER
    });
  }
  if (emptyFieldCount > 0) {
    topAlerts.push({
      key: '-',
      value: emptyFieldCount,
      percentage: Math.round(emptyFieldCount / total * 1000) / 10,
      label: '-'
    });
  }
  return topAlerts;
};
exports.parseAlertsGroupingData = parseAlertsGroupingData;
const getNonEmptyPercent = topAlerts => {
  const consolidated = topAlerts.reduce((ret, cur) => {
    ret.total += cur.value;
    if (cur.key !== '-') {
      ret.nonEmpty += cur.value;
    }
    return ret;
  }, {
    total: 0,
    nonEmpty: 0
  });
  return consolidated.total > 0 ? Math.round(consolidated.nonEmpty / consolidated.total * 100) : 0;
};
exports.getNonEmptyPercent = getNonEmptyPercent;
const getIsAlertsProgressBarData = data => {
  return data === null || data === void 0 ? void 0 : data.every(x => (0, _lodash.has)(x, 'percentage'));
};
exports.getIsAlertsProgressBarData = getIsAlertsProgressBarData;
const getIsAlertsByGroupingAgg = data => {
  return (0, _lodash.has)(data, 'aggregations.alertsByGrouping');
};
exports.getIsAlertsByGroupingAgg = getIsAlertsByGroupingAgg;
const labels = {
  'host.name': i18n.HOST_NAME_LABEL,
  'user.name': i18n.USER_NAME_LABEL,
  'source.ip': i18n.SOURCE_LABEL,
  'destination.ip': i18n.DESTINATION_LABEL
};
const getGroupByLabel = option => {
  return labels[option];
};
exports.getGroupByLabel = getGroupByLabel;