"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionFormField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _kibana = require("../../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ResponseActionFormField = /*#__PURE__*/_react.default.memo(({
  field
}) => {
  const {
    setErrors,
    clearErrors,
    value,
    setValue
  } = field;
  const {
    osquery
  } = (0, _kibana.useKibana)().services;
  const OsqueryForm = (0, _react.useMemo)(() => osquery === null || osquery === void 0 ? void 0 : osquery.OsqueryResponseActionTypeForm, [osquery === null || osquery === void 0 ? void 0 : osquery.OsqueryResponseActionTypeForm]);
  const handleError = (0, _react.useCallback)(newErrors => {
    if ((0, _lodash.isEmpty)(newErrors)) {
      clearErrors();
    } else {
      setErrors((0, _lodash.map)(newErrors, error => ({
        message: error.message
      })));
    }
  }, [setErrors, clearErrors]);

  // @ts-expect-error update types
  return /*#__PURE__*/_react.default.createElement(OsqueryForm, {
    defaultValues: value,
    onError: handleError,
    onChange: setValue
  });
});
exports.ResponseActionFormField = ResponseActionFormField;
ResponseActionFormField.displayName = 'ResponseActionFormField';