"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.api = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _kibana = require("../../../common/lib/kibana");
var _rule_monitoring = require("../../../../common/detection_engine/rule_monitoring");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const api = {
  setupDetectionEngineHealthApi: async () => {
    await http().fetch(_rule_monitoring.SETUP_HEALTH_URL, {
      method: 'POST'
    });
  },
  fetchRuleExecutionEvents: args => {
    const {
      ruleId,
      eventTypes,
      logLevels,
      sortOrder,
      page,
      perPage,
      signal
    } = args;
    const url = (0, _rule_monitoring.getRuleExecutionEventsUrl)(ruleId);
    return http().fetch(url, {
      method: 'GET',
      query: {
        event_types: eventTypes === null || eventTypes === void 0 ? void 0 : eventTypes.join(','),
        log_levels: logLevels === null || logLevels === void 0 ? void 0 : logLevels.join(','),
        sort_order: sortOrder,
        page,
        per_page: perPage
      },
      signal
    });
  },
  fetchRuleExecutionResults: args => {
    var _statusFilters$sort;
    const {
      ruleId,
      start,
      end,
      queryText,
      statusFilters,
      page,
      perPage,
      sortField,
      sortOrder,
      signal
    } = args;
    const url = (0, _rule_monitoring.getRuleExecutionResultsUrl)(ruleId);
    const startDate = _datemath.default.parse(start);
    const endDate = _datemath.default.parse(end, {
      roundUp: true
    });
    return http().fetch(url, {
      method: 'GET',
      query: {
        start: startDate === null || startDate === void 0 ? void 0 : startDate.utc().toISOString(),
        end: endDate === null || endDate === void 0 ? void 0 : endDate.utc().toISOString(),
        query_text: queryText,
        status_filters: statusFilters === null || statusFilters === void 0 ? void 0 : (_statusFilters$sort = statusFilters.sort()) === null || _statusFilters$sort === void 0 ? void 0 : _statusFilters$sort.join(','),
        sort_field: sortField,
        sort_order: sortOrder,
        page,
        per_page: perPage
      },
      signal
    });
  }
};
exports.api = api;
const http = () => _kibana.KibanaServices.get().http;