"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RulesTableToolbar = exports.AllRulesTabs = void 0;
var _react = _interopRequireWildcard(require("react"));
var _user_info = require("../../../../detections/components/user_info");
var _tab_navigation = require("../../../../common/components/navigation/tab_navigation");
var _use_prebuilt_rules_status = require("../../../rule_management/logic/prebuilt_rules/use_prebuilt_rules_status");
var _use_rule_management_filters = require("../../../rule_management/logic/use_rule_management_filters");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AllRulesTabs;
exports.AllRulesTabs = AllRulesTabs;
(function (AllRulesTabs) {
  AllRulesTabs["management"] = "management";
  AllRulesTabs["monitoring"] = "monitoring";
  AllRulesTabs["updates"] = "updates";
})(AllRulesTabs || (exports.AllRulesTabs = AllRulesTabs = {}));
const RulesTableToolbar = /*#__PURE__*/_react.default.memo(() => {
  var _ruleManagementFilter, _ruleManagementFilter2, _prebuiltRulesStatus$;
  const {
    data: ruleManagementFilters
  } = (0, _use_rule_management_filters.useRuleManagementFilters)();
  const {
    data: prebuiltRulesStatus
  } = (0, _use_prebuilt_rules_status.usePrebuiltRulesStatus)();
  const [{
    loading,
    canUserCRUD
  }] = (0, _user_info.useUserData)();
  const installedTotal = ((_ruleManagementFilter = ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.rules_summary.custom_count) !== null && _ruleManagementFilter !== void 0 ? _ruleManagementFilter : 0) + ((_ruleManagementFilter2 = ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.rules_summary.prebuilt_installed_count) !== null && _ruleManagementFilter2 !== void 0 ? _ruleManagementFilter2 : 0);
  const updateTotal = (_prebuiltRulesStatus$ = prebuiltRulesStatus === null || prebuiltRulesStatus === void 0 ? void 0 : prebuiltRulesStatus.num_prebuilt_rules_to_upgrade) !== null && _prebuiltRulesStatus$ !== void 0 ? _prebuiltRulesStatus$ : 0;
  const shouldDisplayRuleUpdatesTab = !loading && canUserCRUD && updateTotal > 0;
  const ruleTabs = (0, _react.useMemo)(() => ({
    [AllRulesTabs.management]: {
      id: AllRulesTabs.management,
      name: i18n.INSTALLED_RULES_TAB,
      disabled: false,
      href: `/rules/${AllRulesTabs.management}`,
      isBeta: installedTotal > 0,
      betaOptions: {
        text: `${installedTotal}`
      }
    },
    [AllRulesTabs.monitoring]: {
      id: AllRulesTabs.monitoring,
      name: i18n.RULE_MONITORING_TAB,
      disabled: false,
      href: `/rules/${AllRulesTabs.monitoring}`,
      isBeta: installedTotal > 0,
      betaOptions: {
        text: `${installedTotal}`
      }
    },
    ...(shouldDisplayRuleUpdatesTab ? {
      [AllRulesTabs.updates]: {
        id: AllRulesTabs.updates,
        name: i18n.RULE_UPDATES_TAB,
        disabled: false,
        href: `/rules/${AllRulesTabs.updates}`,
        isBeta: updateTotal > 0,
        betaOptions: {
          text: `${updateTotal}`
        }
      }
    } : {})
  }), [installedTotal, updateTotal, shouldDisplayRuleUpdatesTab]);
  return /*#__PURE__*/_react.default.createElement(_tab_navigation.TabNavigation, {
    navTabs: ruleTabs
  });
});
exports.RulesTableToolbar = RulesTableToolbar;
RulesTableToolbar.displayName = 'RulesTableToolbar';