"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleSearchField = RuleSearchField;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _eui = require("@elastic/eui");
var _rules_management_tour = require("../rules_table/guided_onboarding/rules_management_tour");
var i18n = _interopRequireWildcard(require("../../../../../detections/pages/detection_engine/rules/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchBarWrapper = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  min-width: 200px;
  & .euiPopover,
  & .euiPopover__anchor {
    // This is needed to "cancel" styles passed down from EuiTourStep that
    // interfere with EuiFieldSearch and don't allow it to take the full width
    display: block;
  }
`;
function RuleSearchField({
  initialValue,
  onSearch,
  placeholder
}) {
  const [searchText, setSearchText] = (0, _react.useState)(initialValue);
  const handleChange = (0, _react.useCallback)(e => setSearchText(e.target.value), [setSearchText]);
  (0, _react.useEffect)(() => {
    setSearchText(initialValue);
  }, [initialValue]);
  return /*#__PURE__*/_react.default.createElement(SearchBarWrapper, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    id: _rules_management_tour.SEARCH_FIRST_RULE_ANCHOR,
    "aria-label": i18n.SEARCH_RULES,
    fullWidth: true,
    incremental: false,
    placeholder: placeholder !== null && placeholder !== void 0 ? placeholder : i18n.SEARCH_PLACEHOLDER,
    value: searchText,
    onChange: handleChange,
    onSearch: onSearch,
    "data-test-subj": "ruleSearchField"
  }));
}