"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RuleExecutionStatusSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var i18n = _interopRequireWildcard(require("../../../../../detections/pages/detection_engine/rules/translations"));
var _execution_status = require("../../../../../../common/detection_engine/rule_monitoring/model/execution_status");
var _utils = require("../../../../../detections/components/rules/rule_execution_status/utils");
var _rule_status_badge = require("../../../../../detections/components/rules/rule_execution_status/rule_status_badge");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Selector for selecting last rule execution status to filter on
 *
 * @param selectedStatus Selected rule execution status
 * @param onSelectedStatusChanged change listener to be notified when rule execution status selection changes
 */
const RuleExecutionStatusSelectorComponent = ({
  selectedStatus,
  onSelectedStatusChanged
}) => {
  const [isExecutionStatusPopoverOpen, setIsExecutionStatusPopoverOpen] = (0, _react.useState)(false);
  const selectableOptions = [{
    label: (0, _utils.getCapitalizedStatusText)(_execution_status.RuleExecutionStatus.succeeded) || '',
    data: {
      status: _execution_status.RuleExecutionStatus.succeeded
    },
    checked: selectedStatus === _execution_status.RuleExecutionStatus.succeeded ? 'on' : undefined
  }, {
    label: (0, _utils.getCapitalizedStatusText)(_execution_status.RuleExecutionStatus['partial failure']) || '',
    data: {
      status: _execution_status.RuleExecutionStatus['partial failure']
    },
    checked: selectedStatus === _execution_status.RuleExecutionStatus['partial failure'] ? 'on' : undefined
  }, {
    label: (0, _utils.getCapitalizedStatusText)(_execution_status.RuleExecutionStatus.failed) || '',
    data: {
      status: _execution_status.RuleExecutionStatus.failed
    },
    checked: selectedStatus === _execution_status.RuleExecutionStatus.failed ? 'on' : undefined
  }];
  const handleSelectableOptionsChange = (newOptions, _, changedOption) => {
    var _changedOption$data;
    setIsExecutionStatusPopoverOpen(false);
    if (changedOption.checked && changedOption !== null && changedOption !== void 0 && (_changedOption$data = changedOption.data) !== null && _changedOption$data !== void 0 && _changedOption$data.status) {
      onSelectedStatusChanged(changedOption.data.status);
    } else if (!changedOption.checked) {
      onSelectedStatusChanged();
    }
  };
  const triggerButton = /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    grow: true,
    iconType: "arrowDown",
    onClick: () => {
      setIsExecutionStatusPopoverOpen(!isExecutionStatusPopoverOpen);
    },
    numFilters: selectableOptions.length,
    isSelected: isExecutionStatusPopoverOpen,
    hasActiveFilters: selectedStatus !== undefined,
    numActiveFilters: selectedStatus !== undefined ? 1 : 0,
    "data-test-subj": "executionStatusFilterButton"
  }, i18n.COLUMN_LAST_RESPONSE);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    ownFocus: true,
    button: triggerButton,
    isOpen: isExecutionStatusPopoverOpen,
    closePopover: () => {
      setIsExecutionStatusPopoverOpen(!isExecutionStatusPopoverOpen);
    },
    panelPaddingSize: "none",
    repositionOnScroll: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelectable, {
    "aria-label": i18n.RULE_EXECTION_STATUS_FILTER,
    options: selectableOptions,
    onChange: handleSelectableOptionsChange,
    singleSelection: true,
    listProps: {
      isVirtualized: false
    },
    renderOption: option => {
      const status = option.status;
      return /*#__PURE__*/_react.default.createElement("div", {
        css: `
                margin-top: 4px; // aligns the badge within the option
              `,
        "data-test-subj": "executionStatusFilterOption"
      }, /*#__PURE__*/_react.default.createElement(_rule_status_badge.RuleStatusBadge, {
        status: status,
        showTooltip: false
      }));
    },
    "data-test-subj": "executionStatusFilterSelectableList"
  }, list => /*#__PURE__*/_react.default.createElement("div", {
    css: `
              width: 200px;
            `
  }, list)));
};
RuleExecutionStatusSelectorComponent.displayName = 'RuleExecutionStatusSelectorComponent';
const RuleExecutionStatusSelector = /*#__PURE__*/_react.default.memo(RuleExecutionStatusSelectorComponent);
exports.RuleExecutionStatusSelector = RuleExecutionStatusSelector;
RuleExecutionStatusSelector.displayName = 'RuleExecutionStatusSelector';