"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TagsForm = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireWildcard(require("react"));
var _use_rule_management_filters = require("../../../../../rule_management/logic/use_rule_management_filters");
var _request_schema = require("../../../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var i18n = _interopRequireWildcard(require("../../../../../../detections/pages/detection_engine/rules/translations"));
var _helpers = require("../../helpers");
var _shared_imports = require("../../../../../../shared_imports");
var _bulk_edit_form_wrapper = require("./bulk_edit_form_wrapper");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const CommonUseField = (0, _shared_imports.getUseField)({
  component: _shared_imports.Field
});
const schema = {
  tags: {
    fieldsToValidateOnChange: ['tags'],
    type: _shared_imports.FIELD_TYPES.COMBO_BOX,
    validations: [{
      validator: _shared_imports.fieldValidators.emptyField(i18n.BULK_EDIT_FLYOUT_FORM_TAGS_REQUIRED_ERROR)
    }]
  },
  overwrite: {
    type: _shared_imports.FIELD_TYPES.CHECKBOX,
    label: i18n.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_OVERWRITE_LABEL
  }
};
const initialFormData = {
  tags: [],
  overwrite: false
};
const getFormConfig = editAction => editAction === _request_schema.BulkActionEditType.add_tags ? {
  tagsLabel: i18n.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_LABEL,
  tagsHelpText: i18n.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_HELP_TEXT,
  formTitle: i18n.BULK_EDIT_FLYOUT_FORM_ADD_TAGS_TITLE
} : {
  tagsLabel: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_LABEL,
  tagsHelpText: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_HELP_TEXT,
  formTitle: i18n.BULK_EDIT_FLYOUT_FORM_DELETE_TAGS_TITLE
};
const TagsFormComponent = ({
  editAction,
  rulesCount,
  onClose,
  onConfirm
}) => {
  const {
    data: ruleManagementFilters
  } = (0, _use_rule_management_filters.useRuleManagementFilters)();
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: initialFormData,
    schema
  });
  const [{
    overwrite
  }] = (0, _shared_imports.useFormData)({
    form,
    watch: ['overwrite']
  });
  const sortedTags = (0, _react.useMemo)(() => {
    var _ruleManagementFilter;
    return (0, _helpers.caseInsensitiveSort)((_ruleManagementFilter = ruleManagementFilters === null || ruleManagementFilters === void 0 ? void 0 : ruleManagementFilters.aggregated_fields.tags) !== null && _ruleManagementFilter !== void 0 ? _ruleManagementFilter : []);
  }, [ruleManagementFilters]);
  const {
    tagsLabel,
    tagsHelpText,
    formTitle
  } = getFormConfig(editAction);
  const handleSubmit = async () => {
    const {
      data,
      isValid
    } = await form.submit();
    if (!isValid) {
      return;
    }
    const payload = {
      value: data.tags,
      type: data.overwrite ? _request_schema.BulkActionEditType.set_tags : editAction
    };
    onConfirm(payload);
  };
  return /*#__PURE__*/_react.default.createElement(_bulk_edit_form_wrapper.BulkEditFormWrapper, {
    form: form,
    onClose: onClose,
    onSubmit: handleSubmit,
    title: formTitle
  }, /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "tags",
    config: {
      ...schema.tags,
      label: tagsLabel,
      helpText: tagsHelpText
    },
    componentProps: {
      idAria: 'bulkEditRulesTags',
      'data-test-subj': 'bulkEditRulesTags',
      euiFieldProps: {
        fullWidth: true,
        placeholder: '',
        noSuggestions: false,
        options: sortedTags.map(label => ({
          label
        }))
      }
    }
  }), editAction === _request_schema.BulkActionEditType.add_tags ? /*#__PURE__*/_react.default.createElement(CommonUseField, {
    path: "overwrite",
    componentProps: {
      idAria: 'bulkEditRulesOverwriteTags',
      'data-test-subj': 'bulkEditRulesOverwriteTags'
    }
  }) : null, overwrite && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    color: "warning",
    size: "s",
    "data-test-subj": "bulkEditRulesTagsWarning"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.detectionEngine.components.allRules.bulkActions.bulkEditFlyoutForm.setTagsWarningCallout",
    defaultMessage: "You\u2019re about to overwrite tags for {rulesCount, plural, one {# selected rule} other {# selected rules}}, press Save to apply changes.",
    values: {
      rulesCount
    }
  }))));
};
const TagsForm = /*#__PURE__*/_react.default.memo(TagsFormComponent);
exports.TagsForm = TagsForm;
TagsForm.displayName = 'TagsForm';