"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkEditFormWrapper = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../shared_imports");
var i18n = _interopRequireWildcard(require("../../../../../../detections/pages/detection_engine/rules/translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkEditFormWrapperComponent = ({
  form,
  title,
  banner,
  children,
  onClose,
  onSubmit,
  flyoutSize = 's'
}) => {
  const simpleFlyoutTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'RulesBulkEditForm'
  });
  const {
    isValid
  } = form;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: onClose,
    "aria-labelledby": simpleFlyoutTitleId,
    size: flyoutSize
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "rulesBulkEditFormTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: simpleFlyoutTitleId
  }, title))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    banner: banner
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form
  }, children)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: onClose,
    flush: "left",
    "data-test-subj": "rulesBulkEditFormCancelBtn"
  }, i18n.BULK_EDIT_FLYOUT_FORM_CANCEL)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    onClick: onSubmit,
    fill: true,
    disabled: isValid === false,
    "data-test-subj": "rulesBulkEditFormSaveBtn"
  }, i18n.BULK_EDIT_FLYOUT_FORM_SAVE)))));
};
const BulkEditFormWrapper = /*#__PURE__*/_react.default.memo(BulkEditFormWrapperComponent);
exports.BulkEditFormWrapper = BulkEditFormWrapper;
BulkEditFormWrapper.displayName = 'BulkEditFormWrapper';