"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BulkActionDuplicateExceptionsConfirmation = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/detection_engine/rule_management/constants");
var _translations = require("./translations");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BulkActionDuplicateExceptionsConfirmationComponent = ({
  onCancel,
  onConfirm,
  rulesCount
}) => {
  const [selectedDuplicateOption, setSelectedDuplicateOption] = (0, _react.useState)(_constants.DuplicateOptions.withExceptions);
  const handleRadioChange = (0, _react.useCallback)(optionId => {
    setSelectedDuplicateOption(optionId);
  }, [setSelectedDuplicateOption]);
  const handleConfirm = (0, _react.useCallback)(() => {
    onConfirm(selectedDuplicateOption);
  }, [onConfirm, selectedDuplicateOption]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    title: _translations.bulkDuplicateRuleActions.MODAL_TITLE(rulesCount),
    onConfirm: handleConfirm,
    cancelButtonText: _translations.bulkDuplicateRuleActions.CANCEL_BUTTON,
    confirmButtonText: _translations.bulkDuplicateRuleActions.CONTINUE_BUTTON,
    defaultFocusedButton: "confirm",
    onCancel: onCancel
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, _translations.bulkDuplicateRuleActions.MODAL_TEXT(rulesCount)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiRadioGroup, {
    options: [{
      id: _constants.DuplicateOptions.withExceptions,
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _translations.bulkDuplicateRuleActions.DUPLICATE_EXCEPTIONS_INCLUDE_EXPIRED_EXCEPTIONS_LABEL(rulesCount), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _translations.bulkDuplicateRuleActions.DUPLICATE_TOOLTIP,
        position: "bottom"
      })),
      'data-test-subj': _constants.DuplicateOptions.withExceptions
    }, {
      id: _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions,
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        size: "s"
      }, _translations.bulkDuplicateRuleActions.DUPLICATE_EXCEPTIONS_TEXT(rulesCount), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _translations.bulkDuplicateRuleActions.DUPLICATE_TOOLTIP,
        position: "bottom"
      })),
      'data-test-subj': _constants.DuplicateOptions.withExceptionsExcludeExpiredExceptions
    }, {
      id: _constants.DuplicateOptions.withoutExceptions,
      label: _translations.bulkDuplicateRuleActions.DUPLICATE_WITHOUT_EXCEPTIONS_TEXT(rulesCount),
      'data-test-subj': _constants.DuplicateOptions.withoutExceptions
    }],
    idSelected: selectedDuplicateOption,
    onChange: handleRadioChange
  }));
};
const BulkActionDuplicateExceptionsConfirmation = /*#__PURE__*/_react.default.memo(BulkActionDuplicateExceptionsConfirmationComponent);
exports.BulkActionDuplicateExceptionsConfirmation = BulkActionDuplicateExceptionsConfirmation;
BulkActionDuplicateExceptionsConfirmation.displayName = 'BulkActionDuplicateExceptionsConfirmation';