"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddPrebuiltRulesTable = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _constants = require("../constants");
var _rules_changelog_link = require("../rules_changelog_link");
var _add_prebuilt_rules_no_items_message = require("./add_prebuilt_rules_no_items_message");
var _add_prebuilt_rules_table_context = require("./add_prebuilt_rules_table_context");
var _add_prebuilt_rules_table_filters = require("./add_prebuilt_rules_table_filters");
var _use_add_prebuilt_rules_table_columns = require("./use_add_prebuilt_rules_table_columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Table Component for displaying new rules that are available to be installed
 */
const AddPrebuiltRulesTable = /*#__PURE__*/_react.default.memo(() => {
  const addRulesTableContext = (0, _add_prebuilt_rules_table_context.useAddPrebuiltRulesTableContext)();
  const {
    state: {
      rules,
      filteredRules,
      isFetched,
      isLoading,
      isRefetching,
      selectedRules,
      isUpgradingSecurityPackages
    },
    actions: {
      selectRules
    }
  } = addRulesTableContext;
  const rulesColumns = (0, _use_add_prebuilt_rules_table_columns.useAddPrebuiltRulesTableColumns)();
  const isTableEmpty = isFetched && rules.length === 0;
  const shouldShowProgress = isUpgradingSecurityPackages || isRefetching;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, shouldShowProgress && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    "data-test-subj": "loadingRulesInfoProgress",
    size: "xs",
    position: "absolute",
    color: "accent"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonLoading, {
    isLoading: isLoading,
    loadingContent: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonTitle, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, null)),
    loadedContent: isTableEmpty ? /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_no_items_message.AddPrebuiltRulesTableNoItemsMessage, null) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_rules_changelog_link.RulesChangelogLink, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_add_prebuilt_rules_table_filters.AddPrebuiltRulesTableFilters, null))), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: filteredRules,
      sorting: true,
      pagination: {
        initialPageSize: _constants.RULES_TABLE_INITIAL_PAGE_SIZE,
        pageSizeOptions: _constants.RULES_TABLE_PAGE_SIZE_OPTIONS
      },
      isSelectable: true,
      selection: {
        selectable: () => true,
        onSelectionChange: selectRules,
        initialSelected: selectedRules
      },
      itemId: "rule_id",
      "data-test-subj": "add-prebuilt-rules-table",
      columns: rulesColumns
    }))
  }));
});
exports.AddPrebuiltRulesTable = AddPrebuiltRulesTable;
AddPrebuiltRulesTable.displayName = 'AddPrebuiltRulesTable';