"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.usePerformInstallSpecificRules = exports.usePerformInstallAllRules = void 0;
var _use_app_toasts = require("../../../../common/hooks/use_app_toasts");
var _use_perform_all_rules_install_mutation = require("../../api/hooks/prebuilt_rules/use_perform_all_rules_install_mutation");
var _use_perform_specific_rules_install_mutation = require("../../api/hooks/prebuilt_rules/use_perform_specific_rules_install_mutation");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const usePerformInstallAllRules = () => {
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _use_perform_all_rules_install_mutation.usePerformAllRulesInstallMutation)({
    onError: err => {
      addError(err, {
        title: i18n.RULE_INSTALLATION_FAILED
      });
    },
    onSuccess: result => {
      addSuccess(getSuccessToastMessage(result));
    }
  });
};
exports.usePerformInstallAllRules = usePerformInstallAllRules;
const usePerformInstallSpecificRules = () => {
  const {
    addError,
    addSuccess
  } = (0, _use_app_toasts.useAppToasts)();
  return (0, _use_perform_specific_rules_install_mutation.usePerformSpecificRulesInstallMutation)({
    onError: err => {
      addError(err, {
        title: i18n.RULE_INSTALLATION_FAILED
      });
    },
    onSuccess: result => {
      addSuccess(getSuccessToastMessage(result));
    }
  });
};
exports.usePerformInstallSpecificRules = usePerformInstallSpecificRules;
const getSuccessToastMessage = result => {
  const toastMessages = [];
  const {
    summary: {
      succeeded,
      skipped,
      failed
    }
  } = result;
  if (succeeded > 0) {
    toastMessages.push(i18n.INSTALL_RULE_SUCCESS(succeeded));
  }
  if (skipped > 0) {
    toastMessages.push(i18n.INSTALL_RULE_SKIPPED(skipped));
  }
  if (failed > 0) {
    toastMessages.push(i18n.INSTALL_RULE_FAILED(failed));
  }
  return toastMessages.join(' ');
};