"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useBulkExport = useBulkExport;
var _react = require("react");
var _request_schema = require("../../../../../common/detection_engine/rule_management/api/rules/bulk_actions/request_schema");
var _rules_table_context = require("../../../rule_management_ui/components/rules_table/rules_table/rules_table_context");
var _use_bulk_export_mutation = require("../../api/hooks/use_bulk_export_mutation");
var _use_show_bulk_error_toast = require("./use_show_bulk_error_toast");
var _use_guess_rule_ids_for_bulk_action = require("./use_guess_rule_ids_for_bulk_action");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useBulkExport() {
  const {
    mutateAsync
  } = (0, _use_bulk_export_mutation.useBulkExportMutation)();
  const showBulkErrorToast = (0, _use_show_bulk_error_toast.useShowBulkErrorToast)();
  const guessRuleIdsForBulkAction = (0, _use_guess_rule_ids_for_bulk_action.useGuessRuleIdsForBulkAction)();
  const rulesTableContext = (0, _rules_table_context.useRulesTableContextOptional)();
  const setLoadingRules = rulesTableContext === null || rulesTableContext === void 0 ? void 0 : rulesTableContext.actions.setLoadingRules;
  const bulkExport = (0, _react.useCallback)(async queryOrIds => {
    try {
      var _queryOrIds$ids;
      setLoadingRules === null || setLoadingRules === void 0 ? void 0 : setLoadingRules({
        ids: (_queryOrIds$ids = queryOrIds.ids) !== null && _queryOrIds$ids !== void 0 ? _queryOrIds$ids : guessRuleIdsForBulkAction(_request_schema.BulkActionType.export),
        action: _request_schema.BulkActionType.export
      });
      return await mutateAsync(queryOrIds);
    } catch (error) {
      showBulkErrorToast({
        actionType: _request_schema.BulkActionType.export,
        error
      });
    } finally {
      setLoadingRules === null || setLoadingRules === void 0 ? void 0 : setLoadingRules({
        ids: [],
        action: null
      });
    }
  }, [guessRuleIdsForBulkAction, setLoadingRules, mutateAsync, showBulkErrorToast]);
  return {
    bulkExport
  };
}