"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsAddToRulesOptions = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _add_to_rules_table = require("../add_to_rules_table");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExceptionsAddToRulesOptionsComponent = ({
  possibleRules,
  isSingleRule,
  isBulkAction,
  selectedRadioOption,
  onRuleSelectionChange,
  onRadioChange
}) => {
  const ruleRadioOptionProps = (0, _react.useMemo)(() => {
    if (isBulkAction && possibleRules != null) {
      return {
        id: 'add_to_rules',
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          "data-test-subj": "addToRulesRadioOption"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          defaultMessage: "Add to [{numRules}] selected rules: {ruleNames}",
          id: "xpack.securitySolution.exceptions.common.addToRulesOptionLabel",
          values: {
            numRules: possibleRules.length,
            ruleNames: /*#__PURE__*/_react.default.createElement("span", {
              style: {
                fontWeight: 'bold'
              }
            }, possibleRules.map(({
              name
            }) => name).join(','))
          }
        })),
        checked: selectedRadioOption === 'add_to_rules',
        'data-test-subj': 'addToRulesOptionsRadio',
        onChange: () => {
          onRadioChange('add_to_rules');
          onRuleSelectionChange(possibleRules);
        }
      };
    }
    if (isSingleRule && possibleRules != null) {
      return {
        id: 'add_to_rule',
        label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          "data-test-subj": "addToRuleRadioOption"
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          defaultMessage: "Add to this rule: {ruleName}",
          id: "xpack.securitySolution.exceptions.common.addToRuleOptionLabel",
          values: {
            ruleName: /*#__PURE__*/_react.default.createElement("span", {
              style: {
                fontWeight: 'bold'
              }
            }, possibleRules[0].name)
          }
        })),
        checked: selectedRadioOption === 'add_to_rule',
        'data-test-subj': 'addToRuleOptionsRadio',
        onChange: () => {
          onRadioChange('add_to_rule');
          onRuleSelectionChange(possibleRules);
        }
      };
    }
    return {
      id: 'select_rules_to_add_to',
      label: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        "data-test-subj": "selectRulesToAddToRadioOption"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Add to rules",
        id: "xpack.securitySolution.exceptions.common.selectRulesOptionLabel"
      })),
      checked: selectedRadioOption === 'select_rules_to_add_to',
      'data-test-subj': 'selectRulesToAddToOptionRadio',
      onChange: () => onRadioChange('select_rules_to_add_to')
    };
  }, [isBulkAction, possibleRules, isSingleRule, selectedRadioOption, onRadioChange, onRuleSelectionChange]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiRadio, ruleRadioOptionProps), selectedRadioOption === 'select_rules_to_add_to' && /*#__PURE__*/_react.default.createElement(_add_to_rules_table.ExceptionsAddToRulesTable, {
    onRuleSelectionChange: onRuleSelectionChange,
    initiallySelectedRules: []
  }));
};
const ExceptionsAddToRulesOptions = /*#__PURE__*/_react.default.memo(ExceptionsAddToRulesOptionsComponent);
exports.ExceptionsAddToRulesOptions = ExceptionsAddToRulesOptions;
ExceptionsAddToRulesOptions.displayName = 'ExceptionsAddToRulesOptions';