"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionsAddToRulesOrLists = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _securitysolutionIoTsListTypes = require("@kbn/securitysolution-io-ts-list-types");
var i18n = _interopRequireWildcard(require("./translations"));
var _add_to_rules_options = require("../add_to_rules_options");
var _add_to_lists_options = require("../add_to_lists_options");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SectionHeader = (0, _styledComponents.default)(_eui.EuiTitle)`
  ${() => (0, _styledComponents.css)`
    font-weight: ${({
  theme
}) => theme.eui.euiFontWeightSemiBold};
  `}
`;
const ExceptionsAddToRulesOrListsComponent = ({
  rules,
  isBulkAction,
  selectedRadioOption,
  onListSelectionChange,
  onRuleSelectionChange,
  onRadioChange
}) => {
  const isSingleRule = (0, _react.useMemo)(() => rules != null && rules.length === 1, [rules]);

  /*
   * Determine what shared lists to display as selectable options for adding the exception item to:
   * - if dealing with a single rule - show any shared exception lists it has attached
   * - if dealing with multiple rules - show only shared exception lists that are common
   * across all of the rules
   */
  const sharedLists = (0, _react.useMemo)(() => {
    var _rules$0$exceptions_l, _rules$0$exceptions_l2, _rules$map;
    if (rules == null) return [];
    if (rules.length === 1) return (_rules$0$exceptions_l = (_rules$0$exceptions_l2 = rules[0].exceptions_list) === null || _rules$0$exceptions_l2 === void 0 ? void 0 : _rules$0$exceptions_l2.filter(list => list.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION)) !== null && _rules$0$exceptions_l !== void 0 ? _rules$0$exceptions_l : [];
    const lists = (_rules$map = rules === null || rules === void 0 ? void 0 : rules.map(rule => rule.exceptions_list != null ? rule.exceptions_list : [])) !== null && _rules$map !== void 0 ? _rules$map : [];
    lists.sort((a, b) => {
      return a.length - b.length;
    });
    const shortestArrOfLists = lists.shift();
    if (shortestArrOfLists == null || !shortestArrOfLists.length) return [];
    return shortestArrOfLists.filter(exceptionListInfo => lists.every(l => l.some(({
      id
    }) => exceptionListInfo.id === id))).filter(list => list.type === _securitysolutionIoTsListTypes.ExceptionListTypeEnum.DETECTION);
  }, [rules]);
  const rulesCount = (0, _react.useMemo)(() => rules != null ? rules.length : 0, [rules]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    hasShadow: false,
    "data-test-subj": "exceptionItemAddToRuleOrListSection"
  }, /*#__PURE__*/_react.default.createElement(SectionHeader, {
    size: "xs"
  }, /*#__PURE__*/_react.default.createElement("h3", null, i18n.ADD_TO_LISTS_SECTION_TITLE)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_add_to_rules_options.ExceptionsAddToRulesOptions, {
    possibleRules: rules,
    isSingleRule: isSingleRule,
    isBulkAction: isBulkAction,
    selectedRadioOption: selectedRadioOption,
    onRuleSelectionChange: onRuleSelectionChange,
    onRadioChange: onRadioChange
  }), /*#__PURE__*/_react.default.createElement(_add_to_lists_options.ExceptionsAddToListsOptions, {
    rulesCount: rulesCount,
    selectedRadioOption: selectedRadioOption,
    sharedLists: sharedLists,
    onListsSelectionChange: onListSelectionChange,
    onRadioChange: onRadioChange
  }));
};
const ExceptionsAddToRulesOrLists = /*#__PURE__*/_react.default.memo(ExceptionsAddToRulesOrListsComponent);
exports.ExceptionsAddToRulesOrLists = ExceptionsAddToRulesOrLists;
ExceptionsAddToRulesOrLists.displayName = 'ExceptionsAddToRulesOrLists';