"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExceptionItemCardHeader = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExceptionItemCardHeader = /*#__PURE__*/(0, _react.memo)(({
  item,
  actions,
  disableActions = false,
  dataTestSubj
}) => {
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  const onItemActionsClick = () => setIsPopoverOpen(isOpen => !isOpen);
  const onClosePopover = () => setIsPopoverOpen(false);
  const itemActions = (0, _react.useMemo)(() => {
    return actions.map(action => /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": `${dataTestSubj}-actionItem-${action.key}`,
      key: action.key,
      icon: action.icon,
      onClick: () => {
        onClosePopover();
        action.onClick();
      }
    }, action.label));
  }, [dataTestSubj, actions]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": dataTestSubj,
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 9
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    textTransform: "uppercase",
    "data-test-subj": `${dataTestSubj}-title`
  }, /*#__PURE__*/_react.default.createElement("h3", null, item.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      isDisabled: disableActions,
      "aria-label": "Exception item actions menu",
      iconType: "boxesHorizontal",
      onClick: onItemActionsClick,
      "data-test-subj": `${dataTestSubj}-actionButton`
    }),
    panelPaddingSize: "none",
    isOpen: isPopoverOpen,
    closePopover: onClosePopover,
    "data-test-subj": `${dataTestSubj}-items`
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: itemActions
  }))));
});
exports.ExceptionItemCardHeader = ExceptionItemCardHeader;
ExceptionItemCardHeader.displayName = 'ExceptionItemCardHeader';