"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFormattedDuration = exports.RuleDurationFormat = void 0;
var _moment = _interopRequireDefault(require("moment"));
var _react = _interopRequireWildcard(require("react"));
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getFormattedDuration = value => {
  if (!value) {
    return '00:00:00:000';
  }
  const duration = _moment.default.duration(value);
  const days = Math.floor(duration.asDays()).toString().padStart(3, '0');
  const hours = Math.floor(duration.asHours() % 24).toString().padStart(2, '0');
  const minutes = Math.floor(duration.asMinutes() % 60).toString().padStart(2, '0');
  const seconds = duration.seconds().toString().padStart(2, '0');
  const ms = duration.milliseconds().toString().padStart(3, '0');
  if (Math.floor(duration.asDays()) > 0) {
    if (Math.floor(duration.asDays()) >= 365) {
      return i18n.GREATER_THAN_YEAR;
    } else {
      return `${days}:${hours}:${minutes}:${seconds}:${ms}`;
    }
  } else {
    return `${hours}:${minutes}:${seconds}:${ms}`;
  }
};

/**
 * Formats duration as (hh:mm:ss:SSS) by default, overflowing to include days
 * as (ddd:hh:mm:ss:SSS) if necessary, and then finally to `> 1 Year`
 * @param props duration as millis, set isSeconds:true to pass in seconds
 * @constructor
 */
exports.getFormattedDuration = getFormattedDuration;
const RuleDurationFormatComponent = props => {
  const {
    duration,
    isSeconds = false,
    allowZero = true
  } = props;
  const formattedDuration = (0, _react.useMemo)(() => {
    // Durations can be buggy and return negative
    if (allowZero && duration >= 0) {
      return getFormattedDuration(isSeconds ? duration * 1000 : duration);
    }
    return i18n.DURATION_NOT_AVAILABLE;
  }, [allowZero, duration, isSeconds]);
  return /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": "rule-duration-format-value"
  }, formattedDuration);
};
const RuleDurationFormat = /*#__PURE__*/_react.default.memo(RuleDurationFormatComponent);
exports.RuleDurationFormat = RuleDurationFormat;
RuleDurationFormat.displayName = 'RuleDurationFormat';