"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.replaceQueryTextAliases = exports.ExecutionLogSearchBar = exports.EXECUTION_LOG_SCHEMA_MAPPING = void 0;
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _eui = require("@elastic/eui");
var _rule_monitoring = require("../../../../../../common/detection_engine/rule_monitoring");
var _rule_monitoring2 = require("../../../../rule_monitoring");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EXECUTION_LOG_SCHEMA_MAPPING = {
  status: 'kibana.alert.rule.execution.status',
  timestamp: '@timestamp',
  duration: 'event.duration',
  message: 'message',
  gapDuration: 'kibana.alert.rule.execution.metrics.execution_gap_duration_s',
  indexDuration: 'kibana.alert.rule.execution.metrics.total_indexing_duration_ms',
  searchDuration: 'kibana.alert.rule.execution.metrics.total_search_duration_ms',
  totalActions: 'kibana.alert.rule.execution.metrics.number_of_triggered_actions',
  schedulingDelay: 'kibana.task.schedule_delay'
};
exports.EXECUTION_LOG_SCHEMA_MAPPING = EXECUTION_LOG_SCHEMA_MAPPING;
const replaceQueryTextAliases = queryText => {
  return Object.entries(EXECUTION_LOG_SCHEMA_MAPPING).reduce((updatedQuery, [key, value]) => {
    return (0, _lodash.replace)(updatedQuery, key, value);
  }, queryText);
};

// This only includes statuses which are or can be final
exports.replaceQueryTextAliases = replaceQueryTextAliases;
const STATUS_FILTERS = [_rule_monitoring.RuleExecutionStatus.succeeded, _rule_monitoring.RuleExecutionStatus.failed, _rule_monitoring.RuleExecutionStatus['partial failure']];
/**
 * SearchBar + StatusFilters component to be used with the Rule Execution Log table
 * NOTE: The SearchBar component is currently not shown in the UI as custom search queries
 * are not yet fully supported by the Rule Execution Log aggregation API since
 * certain queries could result in missing data or inclusion of wrong events.
 * Please see this comment for history/details: https://github.com/elastic/kibana/pull/127339/files#r825240516
 */
const ExecutionLogSearchBar = /*#__PURE__*/_react.default.memo(({
  onlyShowFilters,
  selectedStatuses,
  onStatusFilterChange,
  onSearch
}) => {
  const handleSearch = (0, _react.useCallback)(queryText => {
    onSearch(replaceQueryTextAliases(queryText));
  }, [onSearch]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, !onlyShowFilters && /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    "data-test-subj": "executionLogSearch",
    "aria-label": i18n.RULE_EXECUTION_LOG_SEARCH_PLACEHOLDER,
    placeholder: i18n.RULE_EXECUTION_LOG_SEARCH_PLACEHOLDER,
    onSearch: handleSearch,
    isClearable: true,
    fullWidth: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_rule_monitoring2.ExecutionStatusFilter, {
    items: STATUS_FILTERS,
    selectedItems: selectedStatuses,
    onChange: onStatusFilterChange
  })));
});
exports.ExecutionLogSearchBar = ExecutionLogSearchBar;
ExecutionLogSearchBar.displayName = 'ExecutionLogSearchBar';