"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EditDashboardButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _public = require("@kbn/embeddable-plugin/public");
var _translations = require("../pages/details/translations");
var _kibana = require("../../common/lib/kibana");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditDashboardButtonComponent = ({
  filters,
  query,
  savedObjectId,
  timeRange
}) => {
  const {
    services: {
      dashboard
    }
  } = (0, _kibana.useKibana)();
  const {
    navigateTo
  } = (0, _kibana.useNavigation)();
  const onClick = (0, _react.useCallback)(e => {
    var _dashboard$locator;
    e.preventDefault();
    const url = dashboard === null || dashboard === void 0 ? void 0 : (_dashboard$locator = dashboard.locator) === null || _dashboard$locator === void 0 ? void 0 : _dashboard$locator.getRedirectUrl({
      query,
      filters,
      timeRange,
      dashboardId: savedObjectId,
      viewMode: _public.ViewMode.EDIT
    });
    if (url) {
      navigateTo({
        url
      });
    }
  }, [dashboard === null || dashboard === void 0 ? void 0 : dashboard.locator, query, filters, timeRange, savedObjectId, navigateTo]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "primary",
    "data-test-subj": "dashboardEditButton",
    fill: true,
    iconType: "pencil",
    onClick: onClick
  }, _translations.EDIT_DASHBOARD_BUTTON_TITLE);
};
EditDashboardButtonComponent.displayName = 'EditDashboardComponent';
const EditDashboardButton = /*#__PURE__*/_react.default.memo(EditDashboardButtonComponent);
exports.EditDashboardButton = EditDashboardButton;