"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.sourcererSignalIndexNameSelector = exports.sourcererScopeIdSelector = exports.sourcererKibanaDataViewsSelector = exports.sourcererDefaultDataViewSelector = exports.sourcererDataViewSelector = exports.signalIndexNameSelector = exports.scopeIdSelector = exports.kibanaDataViewsSelector = exports.getSourcererScopeSelector = exports.getSourcererDataViewsSelector = exports.defaultDataViewSelector = exports.dataViewSelector = void 0;
var _reselect = require("reselect");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const sourcererKibanaDataViewsSelector = ({
  sourcerer
}) => sourcerer.kibanaDataViews;
exports.sourcererKibanaDataViewsSelector = sourcererKibanaDataViewsSelector;
const sourcererSignalIndexNameSelector = ({
  sourcerer
}) => sourcerer.signalIndexName;
exports.sourcererSignalIndexNameSelector = sourcererSignalIndexNameSelector;
const sourcererDefaultDataViewSelector = ({
  sourcerer
}) => sourcerer.defaultDataView;
exports.sourcererDefaultDataViewSelector = sourcererDefaultDataViewSelector;
const dataViewSelector = ({
  sourcerer
}, id) => sourcerer.kibanaDataViews.find(dataView => dataView.id === id);
exports.dataViewSelector = dataViewSelector;
const sourcererScopeIdSelector = ({
  sourcerer
}, scopeId) => sourcerer.sourcererScopes[scopeId];
exports.sourcererScopeIdSelector = sourcererScopeIdSelector;
const scopeIdSelector = () => (0, _reselect.createSelector)(sourcererScopeIdSelector, scope => scope);
exports.scopeIdSelector = scopeIdSelector;
const kibanaDataViewsSelector = () => (0, _reselect.createSelector)(sourcererKibanaDataViewsSelector, dataViews => dataViews);
exports.kibanaDataViewsSelector = kibanaDataViewsSelector;
const signalIndexNameSelector = () => (0, _reselect.createSelector)(sourcererSignalIndexNameSelector, signalIndexName => signalIndexName);
exports.signalIndexNameSelector = signalIndexNameSelector;
const defaultDataViewSelector = () => (0, _reselect.createSelector)(sourcererDefaultDataViewSelector, dataViews => dataViews);
exports.defaultDataViewSelector = defaultDataViewSelector;
const sourcererDataViewSelector = () => (0, _reselect.createSelector)(dataViewSelector, dataView => dataView);
exports.sourcererDataViewSelector = sourcererDataViewSelector;
const getSourcererDataViewsSelector = () => {
  const getKibanaDataViewsSelector = kibanaDataViewsSelector();
  const getDefaultDataViewSelector = defaultDataViewSelector();
  const getSignalIndexNameSelector = signalIndexNameSelector();
  return state => {
    const kibanaDataViews = getKibanaDataViewsSelector(state);
    const defaultDataView = getDefaultDataViewSelector(state);
    const signalIndexName = getSignalIndexNameSelector(state);
    return {
      defaultDataView,
      kibanaDataViews,
      signalIndexName
    };
  };
};

/**
 * Attn Future Developer
 * Access sourcererScope.selectedPatterns from
 * hook useSourcererDataView in `common/containers/sourcerer/index`
 * in order to get exclude patterns for searches
 * Access sourcererScope.selectedPatterns
 * from this function for display purposes only
 * */
exports.getSourcererDataViewsSelector = getSourcererDataViewsSelector;
const getSourcererScopeSelector = () => {
  const getDataViewsSelector = getSourcererDataViewsSelector();
  const getSourcererDataViewSelector = sourcererDataViewSelector();
  const getScopeSelector = scopeIdSelector();
  return (state, scopeId) => {
    const dataViews = getDataViewsSelector(state);
    const scope = getScopeSelector(state, scopeId);
    const selectedDataView = getSourcererDataViewSelector(state, scope.selectedDataViewId);
    return {
      ...dataViews,
      selectedDataView,
      sourcererScope: scope
    };
  };
};
exports.getSourcererScopeSelector = getSourcererScopeSelector;